/*
 * Decompiled with CFR 0.152.
 */
package org.alfasoftware.morf.jdbc.h2;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.alfasoftware.morf.jdbc.DatabaseType;
import org.alfasoftware.morf.jdbc.DatabaseTypeIdentifier;
import org.alfasoftware.morf.jdbc.DatabaseTypeIdentifierTestUtils;
import org.alfasoftware.morf.jdbc.JdbcUrlElements;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestH2DatabaseType {
    private DatabaseType databaseType;

    @Before
    public void setup() {
        this.databaseType = DatabaseType.Registry.findByIdentifier((String)"H2");
    }

    @Test
    public void testFormatJdbcUrl() {
        String suffix = ";DB_CLOSE_DELAY=-1;DEFAULT_LOCK_TIMEOUT=150000;LOB_TIMEOUT=2000;MV_STORE=TRUE";
        Assert.assertEquals((Object)("jdbc:h2:tcp://foo.com:123/mem:alfa" + suffix), (Object)this.databaseType.formatJdbcUrl(this.jdbcUrlElementBuilder().withHost("foo.com").withPort(123).withDatabaseName("alfa").build()));
        Assert.assertEquals((Object)("jdbc:h2:tcp://foo.com/mem:alfa" + suffix), (Object)this.databaseType.formatJdbcUrl(this.jdbcUrlElementBuilder().withHost("foo.com").withDatabaseName("alfa").build()));
        Assert.assertEquals((Object)("jdbc:h2:mem:alfa" + suffix), (Object)this.databaseType.formatJdbcUrl(this.jdbcUrlElementBuilder().withDatabaseName("alfa").build()));
        Assert.assertEquals((Object)("jdbc:h2:file:." + File.separator + "alfa" + suffix), (Object)this.databaseType.formatJdbcUrl(this.jdbcUrlElementBuilder().withInstanceName(".").withDatabaseName("alfa").build()));
        Assert.assertEquals((Object)("jdbc:h2:file:bar" + File.separator + "alfa" + suffix), (Object)this.databaseType.formatJdbcUrl(this.jdbcUrlElementBuilder().withInstanceName("bar" + File.separator).withDatabaseName("alfa").build()));
        Assert.assertEquals((Object)"jdbc:h2:mem:data;DB_CLOSE_DELAY=-1;DEFAULT_LOCK_TIMEOUT=150000;LOB_TIMEOUT=2000;MV_STORE=TRUE", (Object)this.databaseType.formatJdbcUrl(this.jdbcUrlElementBuilder().withHost("localhost").withDatabaseName("data").build()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getXADataSourceForH2ShouldThrowException() {
        this.databaseType.getXADataSource(null, null, null);
    }

    @Test
    public void testIdentifyFromMetaData() throws SQLException {
        DataSource dataSource = DatabaseTypeIdentifierTestUtils.mockDataSourceFor((String)"FictiousDB", (String)"9.9.9", (int)9, (int)9);
        Assert.assertEquals(Optional.empty(), (Object)new DatabaseTypeIdentifier(dataSource).identifyFromMetaData());
        ((Connection)Mockito.verify((Object)dataSource.getConnection())).close();
        Assert.assertEquals((Object)this.databaseType, new DatabaseTypeIdentifier(DatabaseTypeIdentifierTestUtils.mockDataSourceFor((String)"H2", (String)"1.3.167 (2012-05-23)", (int)1, (int)3)).identifyFromMetaData().get());
    }

    private JdbcUrlElements.Builder jdbcUrlElementBuilder() {
        return JdbcUrlElements.forDatabaseType((String)"H2");
    }
}

