/*
 * Decompiled with CFR 0.152.
 */
package org.alcibiade.asciiart.jcl;

import java.util.Collection;
import java.util.Map;
import org.alcibiade.asciiart.jcl.Level;
import org.alcibiade.asciiart.jcl.LogDelegator;
import org.alcibiade.asciiart.raster.ExtensibleCharacterRaster;
import org.alcibiade.asciiart.raster.Raster;
import org.alcibiade.asciiart.raster.RasterContext;
import org.alcibiade.asciiart.widget.TableWidget;
import org.alcibiade.asciiart.widget.TextPanel;
import org.alcibiade.asciiart.widget.TextWidget;
import org.alcibiade.asciiart.widget.model.TableModel;
import org.alcibiade.asciiart.widget.model.TableModelCollectionAdapter;
import org.alcibiade.asciiart.widget.model.TableModelMapAdapter;
import org.apache.commons.logging.Log;

public class AsciiArtLog
extends LogDelegator {
    public AsciiArtLog(Log logger) {
        super(logger);
    }

    public void fatal(Collection<? extends Object> items, String title) {
        this.logList(Level.FATAL, items, title);
    }

    public void error(Collection<? extends Object> items, String title) {
        this.logList(Level.ERROR, items, title);
    }

    public void warn(Collection<? extends Object> items, String title) {
        this.logList(Level.WARN, items, title);
    }

    public void info(Collection<? extends Object> items, String title) {
        this.logList(Level.INFO, items, title);
    }

    public void debug(Collection<? extends Object> items, String title) {
        this.logList(Level.DEBUG, items, title);
    }

    public void trace(Collection<? extends Object> items, String title) {
        this.logList(Level.TRACE, items, title);
    }

    public void fatal(Map<? extends Object, ? extends Object> items, String ... titles) {
        this.logMap(Level.FATAL, items, titles);
    }

    public void error(Map<? extends Object, ? extends Object> items, String ... titles) {
        this.logMap(Level.ERROR, items, titles);
    }

    public void warn(Map<? extends Object, ? extends Object> items, String ... titles) {
        this.logMap(Level.WARN, items, titles);
    }

    public void info(Map<? extends Object, ? extends Object> items, String ... titles) {
        this.logMap(Level.INFO, items, titles);
    }

    public void debug(Map<? extends Object, ? extends Object> items, String ... titles) {
        this.logMap(Level.DEBUG, items, titles);
    }

    public void trace(Map<? extends Object, ? extends Object> items, String ... titles) {
        this.logMap(Level.TRACE, items, titles);
    }

    public void fatal(TextWidget widget) {
        this.logWidget(Level.FATAL, widget);
    }

    public void error(TextWidget widget) {
        this.logWidget(Level.ERROR, widget);
    }

    public void warn(TextWidget widget) {
        this.logWidget(Level.WARN, widget);
    }

    public void info(TextWidget widget) {
        this.logWidget(Level.INFO, widget);
    }

    public void debug(TextWidget widget) {
        this.logWidget(Level.DEBUG, widget);
    }

    public void trace(TextWidget widget) {
        this.logWidget(Level.TRACE, widget);
    }

    private void logList(Level level, Collection<? extends Object> items, String title) {
        if (this.isEnabled(level)) {
            TableModelCollectionAdapter tableModel = new TableModelCollectionAdapter(items, title);
            TableWidget tableWidget = new TableWidget((TableModel)tableModel);
            this.doLogWidget(level, (TextWidget)tableWidget);
        }
    }

    private void logMap(Level level, Map<? extends Object, ? extends Object> items, String ... titles) {
        if (this.isEnabled(level)) {
            TableModelMapAdapter tableModel = new TableModelMapAdapter(items, titles);
            TableWidget tableWidget = new TableWidget((TableModel)tableModel);
            this.doLogWidget(level, (TextWidget)tableWidget);
        }
    }

    private void logWidget(Level level, TextWidget widget) {
        if (this.isEnabled(level)) {
            this.doLogWidget(level, widget);
        }
    }

    private void doLogWidget(Level level, TextWidget widget) {
        TextPanel textPanel = new TextPanel();
        textPanel.add(widget);
        ExtensibleCharacterRaster raster = new ExtensibleCharacterRaster(' ');
        textPanel.render(new RasterContext((Raster)raster));
        for (String line : raster) {
            this.logLine(level, line);
        }
    }

    private boolean isEnabled(Level level) {
        boolean enabled = false;
        switch (level) {
            case FATAL: {
                enabled = this.isFatalEnabled();
                break;
            }
            case ERROR: {
                enabled = this.isErrorEnabled();
                break;
            }
            case WARN: {
                enabled = this.isWarnEnabled();
                break;
            }
            case INFO: {
                enabled = this.isInfoEnabled();
                break;
            }
            case DEBUG: {
                enabled = this.isDebugEnabled();
                break;
            }
            case TRACE: {
                enabled = this.isTraceEnabled();
            }
        }
        return enabled;
    }

    private void logLine(Level level, String line) {
        switch (level) {
            case FATAL: {
                this.fatal(line);
                break;
            }
            case ERROR: {
                this.error(line);
                break;
            }
            case WARN: {
                this.warn(line);
                break;
            }
            case INFO: {
                this.info(line);
                break;
            }
            case DEBUG: {
                this.debug(line);
                break;
            }
            case TRACE: {
                this.trace(line);
            }
        }
    }
}

