/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.symlink;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategy;
import org.apache.commons.io.IOUtils;

public class SymbolicLinkStrategyFile
implements SymbolicLinkStrategy {
    protected OpenOption[] openOptions;

    public static SymbolicLinkStrategyFile createDefault() {
        return new SymbolicLinkStrategyFile(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    public static SymbolicLinkStrategyFile createDsync() {
        return new SymbolicLinkStrategyFile(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.DSYNC);
    }

    public SymbolicLinkStrategyFile(OpenOption ... openOptions) {
        this.openOptions = openOptions;
    }

    @Override
    public void createSymbolicLink(Path link, Path target) throws IOException {
        byte[] bytes = target.toString().getBytes(StandardCharsets.UTF_8);
        try (OutputStream out = Files.newOutputStream(link, this.openOptions);){
            out.write(bytes);
            out.flush();
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        try (InputStream in = Files.newInputStream(link, new OpenOption[0]);){
            Path result;
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            String str = new String(bytes, StandardCharsets.UTF_8);
            Path path = result = Paths.get(str, new String[0]);
            return path;
        }
    }

    @Override
    public boolean isSymbolicLink(Path path) {
        boolean result = Files.exists(path, LinkOption.NOFOLLOW_LINKS);
        return result;
    }
}

