/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ReadableByteChannelWithoutCloseOnInterrupt
implements ReadableByteChannel {
    InputStream in;
    private static final int TRANSFER_SIZE = 8192;
    private byte[] buf = new byte[0];
    private boolean open = true;

    public ReadableByteChannelWithoutCloseOnInterrupt(InputStream in) {
        this.in = in;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int totalRead;
        int len = dst.remaining();
        int bytesRead = 0;
        for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
            int bytesToRead = Math.min(len - totalRead, 8192);
            if (this.buf.length < bytesToRead) {
                this.buf = new byte[bytesToRead];
            }
            if (totalRead > 0 && this.in.available() <= 0 || (bytesRead = this.in.read(this.buf, 0, bytesToRead)) < 0) break;
            dst.put(this.buf, 0, bytesRead);
        }
        if (bytesRead < 0 && totalRead == 0) {
            return -1;
        }
        return totalRead;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.open = false;
    }
}

