/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Predicate;
import org.aksw.commons.io.util.channel.ReadableByteChannelDecoratorBase;

public class ReadableByteChannelWithConditionalBound<T extends ReadableByteChannel>
extends ReadableByteChannelDecoratorBase<T> {
    protected Predicate<? super ReadableByteChannelWithConditionalBound<T>> testForEof;
    protected boolean isInEofState = false;
    protected long bytesRead = 0L;

    public ReadableByteChannelWithConditionalBound(T delegate, Predicate<? super ReadableByteChannelWithConditionalBound<T>> testForEof) {
        super(delegate);
        this.testForEof = testForEof;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int result;
        boolean bl = this.isInEofState = this.isInEofState || this.testForEof.test(this);
        if (this.isInEofState) {
            result = -1;
        } else {
            result = this.getDelegate().read(byteBuffer);
            if (result >= 0) {
                this.bytesRead += (long)result;
            } else {
                this.isInEofState = true;
            }
        }
        return result;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

