/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import com.google.common.collect.Lists;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.aksw.commons.io.util.FileChannelUtils;

public class FileUtils {
    public static void deleteRecursivelyIfExists(Path path, RecursiveDeleteOption ... options) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])options);
        }
    }

    public static Path getFirstExistingAncestor(Path path) {
        Path result = path == null ? null : (Files.exists(path, new LinkOption[0]) ? path : FileUtils.getFirstExistingAncestor(path.getParent()));
        return result;
    }

    public static boolean deleteFileIfExistsAndThenDeleteEmptyFolders(Path path, Path baseFolder, boolean alsoDeleteBaseFolder) throws IOException {
        boolean result = Files.deleteIfExists(path);
        if ((path = path.getParent()) != null) {
            FileUtils.deleteEmptyFolders(path, baseFolder, alsoDeleteBaseFolder);
        }
        return result;
    }

    public static void deleteEmptyFolders(Path path, Path baseFolder, boolean alsoDeleteBase) {
        while (path.startsWith(baseFolder) && (alsoDeleteBase || !path.equals(baseFolder))) {
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    break;
                }
            }
            path = path.getParent();
        }
    }

    public static void moveAtomic(Path srcFile, Path tgtPath) throws IOException {
        try {
            Files.move(srcFile, tgtPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            try (FileChannel srcChannel = FileChannel.open(srcFile, StandardOpenOption.READ);
                 FileChannel tgtChannel = FileChannel.open(tgtPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                long n = srcChannel.size();
                FileChannelUtils.transferFromFully(tgtChannel, srcChannel, 0L, n, null);
                tgtChannel.force(true);
            }
            Files.delete(srcFile);
        }
    }

    public void deleteDirectoryIfEmpty(Path path) throws IOException {
        boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
        if (isDirectory) {
            boolean isEmpty;
            boolean bl = isEmpty = Files.list(path).count() == 0L;
            if (isEmpty) {
                Files.delete(path);
            }
        }
    }

    public static List<Path> listPaths(Path basePath, String glob) throws IOException {
        ArrayList result = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(basePath, glob);){
            result = Lists.newArrayList(stream.iterator());
        }
        return result;
    }

    public static <T> T readObject(Path target) throws IOException, ClassNotFoundException {
        Object obj;
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(target, StandardOpenOption.READ));){
            obj = in.readObject();
        }
        return (T)obj;
    }

    public static void writeObject(Path target, Object obj) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(target, StandardOpenOption.WRITE, StandardOpenOption.CREATE));){
            out.writeObject(obj);
            out.flush();
        }
    }

    public static long sizeOfDirectory(Path dirPath) throws IOException {
        return FileUtils.sizeOfDirectory(dirPath, null);
    }

    public static long sizeOfDirectory(Path dirPath, final PathMatcher fileMatcher) throws IOException {
        final AtomicLong totalSize = new AtomicLong(0L);
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                boolean isAccepted;
                boolean bl = isAccepted = fileMatcher == null || fileMatcher.matches(file);
                if (isAccepted) {
                    long contrib = attrs.size();
                    totalSize.addAndGet(contrib);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return totalSize.get();
    }

    public static Stream<Path> ancestors(Path start, boolean reflexive) {
        Stream<Path> r = FileUtils.ancestors(start);
        if (!reflexive) {
            r = r.skip(1L);
        }
        return r;
    }

    public static Stream<Path> ancestors(Path start) {
        return Stream.iterate(start, node -> node.getParent() != null, Path::getParent);
    }

    public static Path findInAncestors(Path start, String fileName) {
        return FileUtils.ancestors(start).filter(folder -> Files.exists(folder.resolve(fileName), new LinkOption[0])).map(folder -> folder.resolve(fileName)).findFirst().orElse(null);
    }
}

