/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.nio.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public class ReadableByteChannelFromInputStream
implements ReadableByteChannel {
    private static final int TRANSFER_SIZE = 8192;
    protected InputStream in;
    protected byte[] buf = new byte[0];
    protected boolean open = true;

    public ReadableByteChannelFromInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result;
        if (!this.open) {
            throw new ClosedChannelException();
        }
        int len = dst.remaining();
        if (dst.hasArray()) {
            int off = dst.position();
            byte[] arr = dst.array();
            result = this.in.read(arr, off, len);
        } else {
            int bytesToRead = Math.min(len, 8192);
            if (this.buf.length < bytesToRead) {
                this.buf = new byte[bytesToRead];
            }
            if ((result = this.in.read(this.buf, 0, len)) > 0) {
                dst.put(this.buf, 0, result);
            }
        }
        return result;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.open = false;
    }
}

