/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.process.util;

import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.exceptions.Exceptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.aksw.commons.io.process.util.OmitSimilarItems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProcessExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SimpleProcessExecutor.class);
    protected ProcessBuilder processBuilder;
    protected Consumer<String> outputSink;
    protected UnaryOperator<Consumer<String>> similarityRemover;
    protected boolean isService;

    public SimpleProcessExecutor(ProcessBuilder processBuilder) {
        this.processBuilder = processBuilder;
        this.outputSink = System.out::println;
        this.similarityRemover = dest -> OmitSimilarItems.forStrings(6, dest);
    }

    public Consumer<String> getOutputSink() {
        return this.outputSink;
    }

    public SimpleProcessExecutor setOutputSink(Consumer<String> outputSink) {
        this.outputSink = outputSink;
        return this;
    }

    public UnaryOperator<Consumer<String>> getSimilarityRemover() {
        return this.similarityRemover;
    }

    public SimpleProcessExecutor setSimilarityRemover(UnaryOperator<Consumer<String>> similarityRemover) {
        this.similarityRemover = similarityRemover;
        return this;
    }

    public boolean isService() {
        return this.isService;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public SimpleProcessExecutor setService(boolean isService) {
        this.isService = isService;
        return this;
    }

    public int watchProcessOutput(Process p) throws IOException, InterruptedException {
        int exitValue;
        Consumer sink = this.similarityRemover == null ? this.outputSink : (Consumer)this.similarityRemover.apply(this.outputSink);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null && !Thread.interrupted()) {
                sink.accept(line);
            }
            exitValue = p.waitFor();
        }
        return exitValue;
    }

    public void run(Process p, FlowableEmitter<Integer> emitter) {
        try {
            int r = this.watchProcessOutput(p);
            emitter.onNext((Object)r);
            emitter.onComplete();
        }
        catch (Exception e) {
            emitter.onError((Throwable)e);
        }
    }

    public Process execute() throws IOException, InterruptedException {
        Process result = this.executeCore().getValue();
        return result;
    }

    public void executeReadLines(Flowable<String> upstream, FlowableEmitter<String> emitter) throws IOException {
        Process p;
        logger.debug("Starting process: " + this.processBuilder.command());
        this.processBuilder.redirectErrorStream(true);
        try {
            p = this.processBuilder.start();
        }
        catch (IOException e1) {
            emitter.onError((Throwable)e1);
            return;
        }
        PrintStream out = new PrintStream(p.getOutputStream());
        InputStream in = p.getInputStream();
        Thread t = new Thread(() -> {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                String line;
                boolean isInterrupted = false;
                while ((line = br.readLine()) != null && !(isInterrupted = Thread.interrupted())) {
                    emitter.onNext((Object)line);
                }
                if (!isInterrupted) {
                    p.waitFor();
                    emitter.onComplete();
                }
                emitter.onComplete();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        t.start();
        Callable<Void> closeAction = () -> {
            out.flush();
            out.close();
            return null;
        };
        emitter.setCancellable(() -> closeAction.call());
        upstream.subscribe(out::println, e -> {
            p.destroy();
            Exceptions.propagate((Throwable)e);
        }, closeAction::call);
    }

    public Single<Integer> executeFuture() throws IOException, InterruptedException {
        Single<Integer> result = this.executeCore().getKey();
        return result;
    }

    public Map.Entry<Single<Integer>, Process> executeCore() throws IOException, InterruptedException {
        logger.debug("Starting process: " + this.processBuilder.command());
        this.processBuilder.redirectErrorStream(true);
        Process p = this.processBuilder.start();
        Single single = Flowable.create(emitter -> {
            if (this.isService) {
                throw new RuntimeException("Do not use; use Single/Flowable.subscribeOn(Schedulers.io)");
            }
            emitter.setCancellable(p::destroyForcibly);
            this.run(p, (FlowableEmitter<Integer>)emitter);
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER).firstOrError();
        return Maps.immutableEntry((Object)single, (Object)p);
    }

    public static SimpleProcessExecutor wrap(ProcessBuilder processBuilder) {
        return new SimpleProcessExecutor(processBuilder);
    }

    private static /* synthetic */ void lambda$executeCore$5(Process p) throws Throwable {
        System.out.println("Destroying process...");
        p.destroy();
        p.waitFor();
        System.out.println("Done");
    }
}

