/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.process.pipe;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aksw.commons.io.endpoint.FileCreation;
import org.aksw.commons.io.process.pipe.InputStreamOrPath;
import org.aksw.commons.io.process.pipe.PathToStream;
import org.aksw.commons.io.process.pipe.ProcessSinkImpl;
import org.aksw.commons.io.process.pipe.StreamToStream;
import org.aksw.commons.util.exception.ExceptionUtilsAksw;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPipeUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPipeUtils.class);

    public static Function<InputStream, InputStream> createPipedTransformer(BiConsumer<InputStream, OutputStream> action) {
        return in -> {
            PipedInputStream pin;
            PipedOutputStream pout = new PipedOutputStream();
            try {
                pin = new PipedInputStream(pout);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            new Thread(() -> {
                try (PipedOutputStream tmpOut = pout;){
                    action.accept((InputStream)in, tmpOut);
                }
                catch (Exception e) {
                    ExceptionUtilsAksw.rethrowUnlessRootCauseMatches((Throwable)e, match -> logger.debug("Channel closed prematurely"), (Predicate[])new Predicate[]{ExceptionUtilsAksw::isClosedChannelException});
                }
            }).start();
            return pin;
        };
    }

    public static Thread startThreadedCopy(InputStream from, OutputStream to, Consumer<Exception> failureCallback) {
        Thread result = new Thread(() -> {
            try (InputStream in = from;
                 OutputStream out = to;){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                failureCallback.accept(e);
                throw new RuntimeException(e);
            }
        });
        result.start();
        return result;
    }

    public static Process startProcess(ProcessBuilder processBuilder) {
        Process result;
        try {
            result = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static PathToStream mapPathToStream(Function<Path, String[]> cmdBuilder) {
        return path -> {
            String[] cmd = (String[])cmdBuilder.apply(path);
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            ProcessSinkImpl r = new ProcessSinkImpl(processBuilder, p -> {});
            return r;
        };
    }

    public static FileCreation createFileCreation(final Process process, Path path) {
        final CompletableFuture future = new CompletableFuture();
        Thread thread = new Thread(() -> {
            try {
                process.waitFor();
                int exitValue = process.exitValue();
                if (exitValue == 0) {
                    future.complete(path);
                } else {
                    future.completeExceptionally(new RuntimeException("Process creating file " + path + " ended with non-zero exit code " + exitValue));
                }
            }
            catch (InterruptedException e) {
                process.destroy();
                future.completeExceptionally(e);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        thread.start();
        FileCreation r = new FileCreation(){

            @Override
            public CompletableFuture<Path> future() {
                return future;
            }

            @Override
            public void abort() throws Exception {
                process.destroy();
            }
        };
        return r;
    }

    public static BiFunction<InputStreamOrPath, Path, FileCreation> mapStreamToPath(Function<Path, String[]> cmdBuilder) {
        return (src, tgt) -> {
            Process process;
            String[] cmd = (String[])cmdBuilder.apply((Path)tgt);
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            if (src.isPath()) {
                processBuilder.redirectInput(src.getPath().toFile());
            }
            try {
                process = processBuilder.start();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            OutputStream out = process.getOutputStream();
            if (!src.isPath()) {
                ProcessPipeUtils.startThreadedCopy(src.getInputStream(), out, e -> process.destroy());
            }
            FileCreation r = ProcessPipeUtils.createFileCreation(process, tgt);
            return r;
        };
    }

    public static BiFunction<Path, Path, FileCreation> mapPathToPath(BiFunction<Path, Path, String[]> cmdBuilder) {
        return (src, tgt) -> {
            Process process;
            String[] cmd = (String[])cmdBuilder.apply((Path)src, (Path)tgt);
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            try {
                process = processBuilder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FileCreation r = ProcessPipeUtils.createFileCreation(process, tgt);
            return r;
        };
    }

    public static StreamToStream mapStreamToStream(String[] cmd) {
        return src -> {
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            if (src.isPath()) {
                processBuilder.redirectInput(src.getPath().toFile());
            }
            ProcessSinkImpl r = new ProcessSinkImpl(processBuilder, p -> {
                if (!src.isPath()) {
                    OutputStream out = p.getOutputStream();
                    ProcessPipeUtils.startThreadedCopy(src.getInputStream(), out, e -> p.destroy());
                }
            });
            return r;
        };
    }
}

