/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.process.pipe;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.commons.io.endpoint.FileCreation;
import org.aksw.commons.io.process.pipe.InputStreamOrPath;
import org.aksw.commons.io.process.pipe.PipeTransform;
import org.aksw.commons.io.process.pipe.ProcessPipeUtils;
import org.aksw.commons.io.process.pipe.SysCallPipeSpec;

public class PipeTransformSysCall
implements PipeTransform {
    protected SysCallPipeSpec pipeSpec;

    public PipeTransformSysCall(SysCallPipeSpec pipeSpec) {
        this.pipeSpec = pipeSpec;
    }

    @Override
    public Function<InputStream, InputStream> mapStreamToStream() {
        return ProcessPipeUtils.mapStreamToStream(this.pipeSpec.cmdStreamToStream()).asStreamTransform();
    }

    @Override
    public BiFunction<InputStream, Path, FileCreation> mapStreamToPath() {
        return (in, path) -> ProcessPipeUtils.mapStreamToPath(this.pipeSpec.cmdBuilderStreamToPath()).apply(InputStreamOrPath.from(in), (Path)path);
    }

    @Override
    public Function<Path, InputStream> mapPathToStream() {
        return ProcessPipeUtils.mapPathToStream(this.pipeSpec.cmdBuilderPathToStream()).asStreamSource();
    }

    @Override
    public BiFunction<Path, Path, FileCreation> mapPathToPath() {
        return (in, path) -> ProcessPipeUtils.mapStreamToPath(this.pipeSpec.cmdBuilderStreamToPath()).apply(InputStreamOrPath.from(in), (Path)path);
    }
}

