/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.process.util;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class OmitSimilarItems<T>
implements Consumer<T> {
    protected BiPredicate<? super T, ? super T> isTooSimilar;
    protected Consumer<? super T> itemDelegate;
    protected Consumer<Long> skipCountDelegate;
    protected T firstDistinguishedItem = null;
    protected T recentlySkippedItem = null;
    protected long numSkippedItems = 0L;

    public OmitSimilarItems(Consumer<? super T> itemDelegate, Consumer<Long> skipCountDelegate, BiPredicate<? super T, ? super T> isTooSimilar) {
        this.itemDelegate = itemDelegate;
        this.skipCountDelegate = skipCountDelegate;
        this.isTooSimilar = isTooSimilar;
    }

    @Override
    public void accept(T item) {
        boolean skip = this.isTooSimilar.test(this.firstDistinguishedItem, item);
        if (skip) {
            this.recentlySkippedItem = item;
            ++this.numSkippedItems;
        } else {
            if (this.numSkippedItems > 0L) {
                boolean recentlySkippedItemDiffersFromCurrentOne;
                boolean bl = recentlySkippedItemDiffersFromCurrentOne = !this.isTooSimilar.test(this.recentlySkippedItem, item);
                if (recentlySkippedItemDiffersFromCurrentOne) {
                    --this.numSkippedItems;
                }
                if (this.numSkippedItems > 0L) {
                    this.skipCountDelegate.accept(this.numSkippedItems);
                }
                if (recentlySkippedItemDiffersFromCurrentOne) {
                    this.itemDelegate.accept(this.recentlySkippedItem);
                }
            }
            this.itemDelegate.accept(item);
            this.firstDistinguishedItem = item;
            this.recentlySkippedItem = null;
            this.numSkippedItems = 0L;
        }
    }

    public static Consumer<String> forStrings(int maxLevenshteinDistance, Consumer<String> delegate) {
        BiPredicate<String, String> predicate = (a, b) -> a == null || b == null ? false : StringUtils.getLevenshteinDistance((CharSequence)a, (CharSequence)b) <= maxLevenshteinDistance;
        OmitSimilarItems<String> result = new OmitSimilarItems<String>(delegate, itemSkipCount -> delegate.accept("  ... " + itemSkipCount + " similar lines omitted ..."), predicate);
        return result;
    }
}

