/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.compress.bzip2;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.aksw.commons.io.hadoop.compress.bzip2.CBZip2InputStreamAdapted;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;
import org.apache.hadoop.io.compress.bzip2.CBZip2OutputStream;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class BZip2CodecAdapted
implements Configurable,
SplittableCompressionCodec {
    private static final String HEADER = "BZ";
    private static final int HEADER_LEN = "BZ".length();
    private static final String SUB_HEADER = "h9";
    private static final int SUB_HEADER_LEN = "h9".length();
    private final int bufferSize;
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public BZip2CodecAdapted() {
        this(-1);
    }

    public BZip2CodecAdapted(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return Bzip2Factory.isNativeBzip2Loaded((Configuration)this.conf) ? new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096)) : new BZip2CompressionOutputStream(out);
    }

    public Class<? extends Compressor> getCompressorType() {
        return Bzip2Factory.getBzip2CompressorType((Configuration)this.conf);
    }

    public Compressor createCompressor() {
        return Bzip2Factory.getBzip2Compressor((Configuration)this.conf);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return Bzip2Factory.isNativeBzip2Loaded((Configuration)this.conf) ? new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096)) : new BZip2CompressionInputStream(in, 0L, Long.MAX_VALUE, SplittableCompressionCodec.READ_MODE.BYBLOCK, this.bufferSize);
    }

    public SplitCompressionInputStream createInputStream(InputStream seekableIn, Decompressor decompressor, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
        if (!(seekableIn instanceof Seekable)) {
            throw new IOException("seekableIn must be an instance of " + Seekable.class.getName());
        }
        ((Seekable)seekableIn).seek(start);
        return new BZip2CompressionInputStream(seekableIn, start, end, readMode, this.bufferSize);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return Bzip2Factory.getBzip2DecompressorType((Configuration)this.conf);
    }

    public Decompressor createDecompressor() {
        return Bzip2Factory.getBzip2Decompressor((Configuration)this.conf);
    }

    public String getDefaultExtension() {
        return ".bz2";
    }

    private static class BZip2CompressionOutputStream
    extends CompressionOutputStream {
        private CBZip2OutputStream output;
        private boolean needsReset = true;

        public BZip2CompressionOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        private void writeStreamHeader() throws IOException {
            if (this.out != null) {
                this.out.write(BZip2CodecAdapted.HEADER.getBytes(StandardCharsets.UTF_8));
            }
        }

        public void finish() throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.finish();
            this.needsReset = true;
        }

        private void internalReset() throws IOException {
            if (this.needsReset) {
                this.needsReset = false;
                this.writeStreamHeader();
                this.output = new CBZip2OutputStream(this.out);
            }
        }

        public void resetState() throws IOException {
            this.needsReset = true;
        }

        public void write(int b) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            this.output.write(b, off, len);
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.output.close();
            }
        }
    }

    private static class BZip2CompressionInputStream
    extends SplitCompressionInputStream {
        private CBZip2InputStreamAdapted input;
        boolean needsReset = false;
        private BufferedInputStream bufferedIn;
        private boolean isHeaderStripped = false;
        private boolean isSubHeaderStripped = false;
        private SplittableCompressionCodec.READ_MODE readMode = SplittableCompressionCodec.READ_MODE.CONTINUOUS;
        private long startingPos = 0L;
        POS_ADVERTISEMENT_STATE_MACHINE posSM = POS_ADVERTISEMENT_STATE_MACHINE.HOLD;
        long compressedStreamPosition = 0L;

        public BZip2CompressionInputStream(InputStream in) throws IOException {
            this(in, 0L, Long.MAX_VALUE, SplittableCompressionCodec.READ_MODE.CONTINUOUS, -1);
        }

        public BZip2CompressionInputStream(InputStream in, long start, long end, SplittableCompressionCodec.READ_MODE readMode, int bufferSize) throws IOException {
            super(in, start, end);
            this.bufferedIn = bufferSize >= 0 ? new BufferedInputStream(this.in, bufferSize) : new BufferedInputStream(this.in);
            this.startingPos = super.getPos();
            this.readMode = readMode;
            long numSkipped = 0L;
            if (this.startingPos == 0L) {
                this.bufferedIn = this.readStreamHeader();
            } else if (this.readMode == SplittableCompressionCodec.READ_MODE.BYBLOCK && this.startingPos <= (long)(HEADER_LEN + SUB_HEADER_LEN)) {
                long skipBytes = numSkipped = (long)(HEADER_LEN + SUB_HEADER_LEN + 1) - this.startingPos;
                while (skipBytes > 0L) {
                    long s = this.bufferedIn.skip(skipBytes);
                    if (s > 0L) {
                        skipBytes -= s;
                        continue;
                    }
                    if (this.bufferedIn.read() == -1) break;
                    --skipBytes;
                }
            }
            this.input = new CBZip2InputStreamAdapted(this.bufferedIn, readMode);
            if (this.isHeaderStripped) {
                this.input.updateReportedByteCount(HEADER_LEN);
            }
            if (this.isSubHeaderStripped) {
                this.input.updateReportedByteCount(SUB_HEADER_LEN);
            }
            if (numSkipped > 0L) {
                this.input.updateReportedByteCount((int)numSkipped);
            }
            if (this.readMode != SplittableCompressionCodec.READ_MODE.BYBLOCK || this.startingPos != 0L) {
                this.updatePos(false);
            }
        }

        private BufferedInputStream readStreamHeader() throws IOException {
            if (this.in != null) {
                this.bufferedIn.mark(HEADER_LEN);
                byte[] headerBytes = new byte[HEADER_LEN];
                int actualRead = this.bufferedIn.read(headerBytes, 0, HEADER_LEN);
                if (actualRead != -1) {
                    String header = new String(headerBytes, StandardCharsets.UTF_8);
                    if (header.compareTo(BZip2CodecAdapted.HEADER) != 0) {
                        this.bufferedIn.reset();
                    } else {
                        this.isHeaderStripped = true;
                        if (this.readMode == SplittableCompressionCodec.READ_MODE.BYBLOCK && (actualRead = this.bufferedIn.read(headerBytes, 0, SUB_HEADER_LEN)) != -1) {
                            this.isSubHeaderStripped = true;
                        }
                    }
                }
            }
            if (this.bufferedIn == null) {
                throw new IOException("Failed to read bzip2 stream.");
            }
            return this.bufferedIn;
        }

        public void close() throws IOException {
            if (!this.needsReset) {
                try {
                    this.input.close();
                    this.needsReset = true;
                }
                finally {
                    super.close();
                }
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.needsReset) {
                this.internalReset();
            }
            int result = 0;
            result = this.input.read(b, off, len);
            if (result == -2) {
                this.posSM = POS_ADVERTISEMENT_STATE_MACHINE.ADVERTISE;
            }
            if (this.posSM == POS_ADVERTISEMENT_STATE_MACHINE.ADVERTISE) {
                result = this.input.read(b, off, off + 1);
                this.updatePos(true);
                this.posSM = POS_ADVERTISEMENT_STATE_MACHINE.HOLD;
            }
            return result;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int result = this.read(b, 0, 1);
            return result < 0 ? result : b[0] & 0xFF;
        }

        private void internalReset() throws IOException {
            if (this.needsReset) {
                this.needsReset = false;
                BufferedInputStream bufferedIn = this.readStreamHeader();
                this.input = new CBZip2InputStreamAdapted(bufferedIn, this.readMode);
            }
        }

        public void resetState() throws IOException {
            this.needsReset = true;
        }

        public long getPos() {
            return this.compressedStreamPosition;
        }

        private void updatePos(boolean shouldAddOn) {
            int addOn = shouldAddOn ? 1 : 0;
            this.compressedStreamPosition = this.startingPos + this.input.getProcessedByteCount() + (long)addOn;
        }

        private static enum POS_ADVERTISEMENT_STATE_MACHINE {
            HOLD,
            ADVERTISE;

        }
    }
}

