/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.hadoop.SeekableInputStream;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchLevelCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchResourceCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchUtils;
import org.aksw.commons.io.hadoop.binseach.v2.HeaderRecord;
import org.aksw.commons.io.hadoop.binseach.v2.Match;
import org.aksw.commons.io.hadoop.binseach.v2.SearchMode;
import org.aksw.commons.io.hadoop.binseach.v2.SeekableReadableChannelSourceOverNio;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSources;
import org.aksw.commons.io.input.ReadableChannelSupplier;
import org.aksw.commons.io.input.ReadableChannelWithLimitByDelimiter;
import org.aksw.commons.io.input.ReadableChannelWithSkipDelimiter;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.ReadableSource;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelSource;
import org.aksw.commons.io.input.SeekableReadableSourceWithMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinarySearcherOverPlainSource
implements BinarySearcher {
    private static final Logger logger = LoggerFactory.getLogger(BinarySearcherOverPlainSource.class);
    protected SeekableReadableChannelSource<byte[]> source;
    protected Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier;

    protected BinarySearcherOverPlainSource(SeekableReadableChannelSource<byte[]> source, Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier) {
        this.source = source;
        this.cacheSupplier = cacheSupplier;
    }

    public void close() throws Exception {
    }

    public static Match binarySearch(SeekableInputStream channel, long end, byte[] prefix) throws IOException {
        return BinarySearcherOverPlainSource.binarySearch(channel, SearchMode.BOTH, 0, 0L, end, end, (byte)10, prefix, BinSearchLevelCache.noCache());
    }

    public static BinarySearcherOverPlainSource of(SeekableReadableChannelSource<byte[]> source, Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier) {
        return new BinarySearcherOverPlainSource(source, cacheSupplier);
    }

    public static BinarySearcherOverPlainSource of(Path path, Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier) {
        return BinarySearcherOverPlainSource.of(new SeekableReadableChannelSourceOverNio(path), cacheSupplier);
    }

    public InputStream search(byte[] prefix) throws IOException {
        BinSearchLevelCache levelCache;
        BinSearchResourceCache.CacheEntry cacheEntry = this.cacheSupplier.get();
        BinSearchLevelCache binSearchLevelCache = levelCache = cacheEntry == null ? null : cacheEntry.levelCache();
        if (levelCache == null) {
            levelCache = BinSearchLevelCache.noCache();
        }
        SeekableReadableChannel channel = this.source.newReadableChannel();
        long searchRangeEnd = this.source.size();
        InputStream result = BinSearchUtils.configureStream((SeekableReadableChannel<byte[]>)channel, searchRangeEnd, prefix, levelCache);
        SeekableReadableChannelSource<byte[]> seekableReadableChannelSource = this.source;
        if (seekableReadableChannelSource instanceof SeekableReadableSourceWithMonitor) {
            SeekableReadableSourceWithMonitor m = (SeekableReadableSourceWithMonitor)seekableReadableChannelSource;
            System.err.println(String.format("Total Reads: %d - Total read amount: %d", m.getChannelMonitor().getReadCounter(), m.getChannelMonitor().getReadAmount()));
        }
        return result;
    }

    public Stream<ReadableChannelSupplier<byte[]>> parallelSearch(byte[] prefix) throws IOException {
        Stream<ReadableChannelSupplier<byte[]>> result = prefix == null || prefix.length == 0 ? ReadableChannelSources.splitBySize(this.source, (long)50000000L).map(split -> () -> {
            try {
                SeekableReadableChannel channel;
                long start = split.getStart();
                long end = split.getEnd();
                int skipCount = start == 0L ? 0 : 1;
                SeekableReadableChannel seekable = channel = this.source.newReadableChannel(start);
                channel = new ReadableChannelWithLimitByDelimiter((ReadableChannel)channel, () -> ((SeekableReadableChannel)seekable).position(), false, 10, end);
                if (skipCount > 0) {
                    channel = new ReadableChannelWithSkipDelimiter((ReadableChannel)channel, 10, skipCount);
                }
                return channel;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }) : super.parallelSearch(prefix);
        return result;
    }

    public static Match binarySearch(SeekableInputStream in, SearchMode searchMode, int depth, long start, long end, long knownDelimPos, byte delimiter, byte[] prefix, BinSearchLevelCache cache) throws IOException {
        Match result;
        if (start > end) {
            return null;
        }
        long mid = start + end >> 1;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("%d <= %d < %d)", start, mid, end));
        }
        int cmp = 0;
        long nextDelimPos = cache.getDisposition(mid);
        long bytesToNextDelimiter = -1L;
        if (nextDelimPos == -1L) {
            in.position(mid);
            if (mid > 0L) {
                long allowedSearchBytes = knownDelimPos - mid - (long)prefix.length + 1L;
                bytesToNextDelimiter = BinSearchUtils.readUntilDelimiter((InputStream)((Object)in), delimiter, allowedSearchBytes);
            }
            nextDelimPos = bytesToNextDelimiter < 0L ? knownDelimPos : mid + bytesToNextDelimiter;
            cache.setDisposition(depth, mid, nextDelimPos);
        }
        if (nextDelimPos == knownDelimPos) {
            cmp = -1;
        }
        if (cmp == 0) {
            int l;
            HeaderRecord headerRecord = cache.getHeader(nextDelimPos);
            if (headerRecord == null || headerRecord.data().length < prefix.length && !headerRecord.isDataConsumed()) {
                if (bytesToNextDelimiter == -1L) {
                    in.position(nextDelimPos);
                }
                boolean isDataConsumed = false;
                int blockSize = Math.max(prefix.length, 256);
                byte[] header = new byte[blockSize];
                int n = ReadableChannels.readFully((ReadableSource)ReadableChannels.wrap((InputStream)((Object)in)), (Object)header, (int)0, (int)blockSize);
                if (n < blockSize) {
                    isDataConsumed = true;
                    header = Arrays.copyOf(header, n);
                }
                headerRecord = new HeaderRecord(nextDelimPos, 0, header, isDataConsumed);
                cache.setHeader(depth, headerRecord);
            }
            if (cmp == 0 && (cmp = Arrays.compare(prefix, 0, l = Math.min(prefix.length, headerRecord.data().length), headerRecord.data(), 0, l)) == 0 && l < prefix.length) {
                cmp = 1;
            }
        }
        if (cmp == 0) {
            boolean findEndOfRun;
            Match expandLeft;
            long candidateResult;
            long left = candidateResult = nextDelimPos;
            long right = candidateResult;
            if ((SearchMode.LEFT.equals((Object)searchMode) || SearchMode.BOTH.equals((Object)searchMode)) && (expandLeft = BinarySearcherOverPlainSource.binarySearch(in, SearchMode.LEFT, depth + 1, start, mid - 1L, nextDelimPos, delimiter, prefix, cache)) != null) {
                left = expandLeft.start();
            }
            if (findEndOfRun = false) {
                // empty if block
            }
            result = new Match(left, right);
        } else {
            result = cmp < 0 ? BinarySearcherOverPlainSource.binarySearch(in, searchMode, depth + 1, start, mid - 1L, nextDelimPos, delimiter, prefix, cache) : BinarySearcherOverPlainSource.binarySearch(in, searchMode, depth + 1, nextDelimPos + 1L, end, knownDelimPos, delimiter, prefix, cache);
        }
        return result;
    }
}

