/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.sansa_stack.io.util.InputStreamWithZeroOffsetRead;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.hadoop.SeekableInputStreams;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchLevelCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchResourceCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchUtils;
import org.aksw.commons.io.hadoop.binseach.v2.Block;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSource;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSourceChannel;
import org.aksw.commons.io.hadoop.binseach.v2.HeaderRecord;
import org.aksw.commons.io.hadoop.binseach.v2.Match;
import org.aksw.commons.io.hadoop.binseach.v2.SearchMode;
import org.aksw.commons.io.hadoop.binseach.v2.SeekableReadableChannelOverBlocks;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSource;
import org.aksw.commons.io.input.ReadableChannelSources;
import org.aksw.commons.io.input.ReadableChannelSupplier;
import org.aksw.commons.io.input.ReadableChannelWithLimitByDelimiter;
import org.aksw.commons.io.input.ReadableChannelWithSkipDelimiter;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.ReadableSource;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelSource;
import org.aksw.commons.io.input.SeekableReadableSourceWithMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinarySearcherOverBlockSource
implements BinarySearcher {
    private static final Logger logger = LoggerFactory.getLogger(BinarySearcherOverBlockSource.class);
    protected BlockSource blockSource;
    protected Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier;

    public BinarySearcherOverBlockSource(BlockSource blockSource, Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier) {
        this.blockSource = blockSource;
        this.cacheSupplier = cacheSupplier;
    }

    public void close() throws Exception {
    }

    public InputStream search(byte[] prefix) throws IOException {
        SeekableReadableChannelSource<byte[]> seekableReadableChannelSource;
        InputStream result;
        Match match;
        BinSearchLevelCache levelCache;
        BinSearchResourceCache.CacheEntry cacheEntry = this.cacheSupplier.get();
        BinSearchLevelCache binSearchLevelCache = levelCache = cacheEntry == null ? null : cacheEntry.levelCache();
        if (levelCache == null) {
            levelCache = BinSearchLevelCache.noCache();
        }
        if ((match = BinarySearcherOverBlockSource.binarySearch(this.blockSource, prefix, levelCache)) != null) {
            Cache blockCache;
            Cache cache = blockCache = cacheEntry == null ? null : cacheEntry.blockCache();
            if (blockCache == null) {
                blockCache = Caffeine.newBuilder().maximumSize(16L).build();
            }
            long startBlockId = match.start();
            SeekableReadableChannelOverBlocks channel = new SeekableReadableChannelOverBlocks(this.blockSource, startBlockId, (Cache<Long, Block>)blockCache);
            long blockSize = channel.getStartingBlockSize();
            blockSize = 900000L;
            result = BinSearchUtils.configureStream((SeekableReadableChannel<byte[]>)channel, blockSize * 2L, prefix, BinSearchLevelCache.noCache());
            boolean showKnownBlocks = false;
            if (showKnownBlocks) {
                for (Block block : channel.getKnownBlocks()) {
                    System.out.println("BLOCK " + block.getThisBlockId());
                    System.out.println("===============================================");
                    byte[] buffer = new byte[(int)block.getBuffer().size()];
                    block.getBuffer().readInto((Object)buffer, 0, 0L, buffer.length);
                    System.err.println(new String(buffer, StandardCharsets.UTF_8));
                }
            }
        } else {
            result = InputStream.nullInputStream();
        }
        if ((seekableReadableChannelSource = this.blockSource.getDelegate()) instanceof SeekableReadableSourceWithMonitor) {
            SeekableReadableSourceWithMonitor m = (SeekableReadableSourceWithMonitor)seekableReadableChannelSource;
            System.err.println(String.format("Total Reads: %d - Total read amount: %d", m.getChannelMonitor().getReadCounter(), m.getChannelMonitor().getReadAmount()));
        }
        return result;
    }

    public Stream<ReadableChannelSupplier<byte[]>> parallelSearch(byte[] prefix) throws IOException {
        Stream<ReadableChannelSupplier<byte[]>> result = prefix == null || prefix.length == 0 ? ReadableChannelSources.splitBySize((ReadableChannelSource)this.blockSource, (long)5000000L).map(split -> () -> {
            try {
                long start = split.getStart();
                long end = split.getEnd();
                int skipCount = start == 0L ? 0 : 1;
                BlockSourceChannel channel = this.blockSource.newReadableChannel(start, true);
                SeekableReadableChannel seekable = channel;
                channel = new ReadableChannelWithLimitByDelimiter((ReadableChannel)channel, () -> ((SeekableReadableChannel)seekable).position(), true, 10, end);
                if (skipCount > 0) {
                    channel = new ReadableChannelWithSkipDelimiter((ReadableChannel)channel, 10, skipCount);
                }
                return channel;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }) : super.parallelSearch(prefix);
        return result;
    }

    public static Match binarySearch(BlockSource blockSource, byte[] prefix, BinSearchLevelCache cache) throws IOException {
        long end = blockSource.size();
        long startAfter = BinarySearcherOverBlockSource.adjustStart(blockSource, 1L, 0, cache);
        Match result = BinarySearcherOverBlockSource.binarySearch(blockSource, SearchMode.BOTH, 0, 0L, startAfter, end, (byte)10, prefix, cache);
        return result;
    }

    public static long adjustStart(BlockSource blockSource, long start, int depth, BinSearchLevelCache cache) throws IOException {
        long currentBlockId = cache.getDisposition(start);
        if (currentBlockId == -1L) {
            try (BlockSourceChannel channel = blockSource.newReadableChannel(start);){
                currentBlockId = channel.getStartingBlockId();
                if (currentBlockId == -1L) {
                    throw new IllegalStateException("Should not happen: Block id not set after read.");
                }
                cache.setDisposition(depth, start, currentBlockId);
            }
        }
        return currentBlockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Match binarySearch(BlockSource blockSource, SearchMode searchMode, int depth, long start, long startAfter, long end, byte delimiter, byte[] prefix, BinSearchLevelCache cache) throws IOException {
        Match result;
        long nextBlockId;
        if (start > end) {
            return null;
        }
        long mid = start + end >> 1;
        if (mid > start && mid <= startAfter) {
            mid = startAfter;
        }
        int cmp = 0;
        try (InputStream in = null;){
            if (mid > 0L) {
                nextBlockId = cache.getDisposition(mid);
                if (nextBlockId == -1L) {
                    BlockSourceChannel channel = blockSource.newReadableChannel(mid);
                    in = new InputStreamWithZeroOffsetRead((InputStream)((Object)SeekableInputStreams.create(channel)));
                    long startBlockId = channel.getStartingBlockId();
                    long currentBlockId = channel.getCurrentBlockId();
                    if (startBlockId == -1L) {
                        throw new IllegalStateException("Should not happen: Block id not set after read.");
                    }
                    nextBlockId = startBlockId;
                    cache.setDisposition(depth, mid, startBlockId);
                }
            } else {
                nextBlockId = 0L;
            }
            HeaderRecord headerRecord = cache.getHeader(nextBlockId);
            int l = prefix.length;
            if (headerRecord == null || headerRecord.data().length < prefix.length && !headerRecord.isDataConsumed()) {
                long bytesToNextDelimiter;
                int blockSize = Math.max(prefix.length, 256);
                byte[] header = new byte[blockSize];
                if (in == null) {
                    BlockSourceChannel channel = blockSource.newReadableChannel(mid);
                    in = new InputStreamWithZeroOffsetRead((InputStream)((Object)SeekableInputStreams.create(channel)));
                }
                if ((bytesToNextDelimiter = BinSearchUtils.readUntilDelimiter(in, delimiter, Long.MAX_VALUE)) < 0L) {
                    cmp = -1;
                } else {
                    boolean isDataConsumed = false;
                    int n = ReadableChannels.readFully((ReadableSource)ReadableChannels.wrap((InputStream)in), (Object)header, (int)0, (int)blockSize);
                    if (n < blockSize) {
                        isDataConsumed = true;
                        header = Arrays.copyOf(header, n);
                    }
                    if (header.length < prefix.length) {
                        cmp = -1;
                    }
                    headerRecord = new HeaderRecord(nextBlockId, (int)bytesToNextDelimiter, header, isDataConsumed);
                    cache.setHeader(depth, headerRecord);
                }
            }
            if (cmp == 0) {
                cmp = Arrays.compare(prefix, 0, l, headerRecord.data(), 0, l);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("  Compared: %s %s %s", new String(prefix, 0, l, StandardCharsets.UTF_8), cmp < 0 ? "<" : (cmp > 0 ? ">" : "=="), new String(headerRecord.data(), 0, l, StandardCharsets.UTF_8)));
                }
            }
        }
        if (cmp == 0) {
            long nextStartAfter;
            Match expandRight;
            long nextStart;
            boolean findEndOfRun;
            long nextEnd;
            Match expandLeft;
            long candidateResult;
            long left = candidateResult = nextBlockId;
            long right = candidateResult;
            if ((SearchMode.LEFT.equals((Object)searchMode) || SearchMode.BOTH.equals((Object)searchMode)) && nextBlockId != 0L && mid != start && (expandLeft = BinarySearcherOverBlockSource.binarySearch(blockSource, SearchMode.LEFT, depth, start, startAfter, nextEnd = mid <= startAfter ? start : mid, delimiter, prefix, cache)) != null) {
                left = expandLeft.start();
            }
            if ((findEndOfRun = true) && (SearchMode.RIGHT.equals((Object)searchMode) || SearchMode.BOTH.equals((Object)searchMode)) && (nextStart = nextBlockId + 1L) <= end && (expandRight = BinarySearcherOverBlockSource.binarySearch(blockSource, SearchMode.RIGHT, depth, nextStart, nextStartAfter = BinarySearcherOverBlockSource.adjustStart(blockSource, nextStart + 1L, depth, cache), end, delimiter, prefix, cache)) != null) {
                right = expandRight.end();
            }
            result = new Match(left, right);
        } else if (cmp < 0) {
            result = mid == start ? new Match(start, start) : (mid <= startAfter ? BinarySearcherOverBlockSource.binarySearch(blockSource, searchMode, depth, start, startAfter, start, delimiter, prefix, cache) : BinarySearcherOverBlockSource.binarySearch(blockSource, searchMode, depth, start, startAfter, mid, delimiter, prefix, cache));
        } else {
            long nextStart = nextBlockId;
            if (end <= startAfter) {
                result = new Match(start, start);
            } else {
                long nextStartAfter = BinarySearcherOverBlockSource.adjustStart(blockSource, nextStart + 1L, depth, cache);
                result = BinarySearcherOverBlockSource.binarySearch(blockSource, searchMode, depth, nextStart, nextStartAfter, end, delimiter, prefix, cache);
            }
        }
        return result;
    }
}

