/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import org.aksw.commons.io.hadoop.binseach.v2.BinSearchCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchCacheFixed;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchCacheFluid;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearchCacheNoop;
import org.aksw.commons.io.hadoop.binseach.v2.HeaderRecord;

public class BinSearchLevelCache {
    protected int fluidLevel;
    protected BinSearchCache fixedCache;
    protected BinSearchCache fluidCache;

    public BinSearchLevelCache() {
        this(16, new BinSearchCacheFixed(), new BinSearchCacheFluid());
    }

    public BinSearchLevelCache(int fluidLevel, BinSearchCache fixedCache, BinSearchCache flowCache) {
        this.fluidLevel = fluidLevel;
        this.fixedCache = fixedCache;
        this.fluidCache = flowCache;
    }

    public HeaderRecord getHeader(long position) {
        HeaderRecord result = this.fixedCache.getHeader(position);
        if (result == null) {
            this.fluidCache.getHeader(position);
        }
        return result;
    }

    public void setHeader(int depth, HeaderRecord headerRecord) {
        BinSearchCache target = depth < this.fluidLevel ? this.fixedCache : this.fluidCache;
        target.setHeader(headerRecord);
    }

    public long getDisposition(long position) {
        long result = this.fixedCache.getDisposition(position);
        if (result < 0L) {
            this.fluidCache.getDisposition(position);
        }
        return result;
    }

    public void setDisposition(int depth, long from, long to) {
        BinSearchCache target = depth < this.fluidLevel ? this.fixedCache : this.fluidCache;
        target.setDisposition(from, to);
    }

    public static BinSearchLevelCache noCache() {
        return new BinSearchLevelCache(0, new BinarySearchCacheNoop(), new BinarySearchCacheNoop());
    }

    public static BinSearchLevelCache dftCache() {
        return new BinSearchLevelCache();
    }
}

