/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.input.ReadableChannelBase;
import org.apache.hadoop.fs.Seekable;

public class ReadableChannelWithBlockAdvertisementBuffered
extends ReadableChannelBase<byte[]> {
    protected InputStream decodedIn;
    protected Seekable seekable;
    protected long startPos;
    protected long currentPos;
    protected byte[] buffer;
    protected byte pendingByte;
    protected int pendingByteState;
    protected int endOfBlockMarker;
    protected long readCount = 0L;

    public ReadableChannelWithBlockAdvertisementBuffered(InputStream decodedIn) throws IOException {
        this(decodedIn, -2);
    }

    public ReadableChannelWithBlockAdvertisementBuffered(InputStream decodedIn, int endOfBlockMarker) throws IOException {
        this.decodedIn = decodedIn;
        this.buffer = new byte[8192];
        this.seekable = (Seekable)decodedIn;
        this.endOfBlockMarker = endOfBlockMarker;
        this.currentPos = this.startPos = this.seekable.getPos();
    }

    public long position() throws IOException {
        return this.seekable.getPos();
    }

    public long getStartPos() {
        return this.startPos;
    }

    public long getCurrentPos() {
        return this.currentPos == 0L ? 0L : this.currentPos - 1L;
    }

    public int read(byte[] array, int position, int length) throws IOException {
        int result;
        if (length <= 0) {
            throw new IllegalArgumentException("length must be non-zero and positive");
        }
        if (this.pendingByteState == 1) {
            this.pendingByteState = 2;
            result = -2;
        } else if (this.pendingByteState == 2) {
            array[position] = this.pendingByte;
            result = 1;
            this.pendingByteState = 0;
        } else {
            int l = Math.min(length, this.buffer.length);
            result = this.decodedIn.read(this.buffer, 0, l);
            if (result > 0) {
                long nextPos = this.seekable.getPos();
                long effectiveCurrentPos = this.getCurrentPos();
                if (effectiveCurrentPos != nextPos - 1L) {
                    this.pendingByte = this.buffer[--result];
                    if (result == 0) {
                        result = -2;
                        this.pendingByteState = 2;
                    } else {
                        this.pendingByteState = 1;
                    }
                    this.currentPos = nextPos;
                }
                if (result > 0) {
                    this.getArrayOps().copy((Object)this.buffer, 0, (Object)array, position, result);
                }
            }
        }
        if (result > 0) {
            this.readCount += (long)result;
        }
        return result;
    }

    protected int onBlockEnd(ByteBuffer dst, long oldPos, long newPos) {
        return this.endOfBlockMarker;
    }

    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    public boolean adjustToNextBlock() throws IOException {
        int tmp;
        byte[] buf = new byte[8192];
        int bytesRead = 0;
        while ((tmp = this.read(buf, 0, buf.length)) >= 0) {
            bytesRead += tmp;
        }
        System.out.println("Bytes read: " + bytesRead);
        boolean result = tmp == -2;
        return result;
    }
}

