/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.bz2;

import java.io.IOException;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.io.util.channel.ChannelFactory;
import org.aksw.commons.util.ref.Ref;

public class DecodedDataBlock
implements Block {
    protected BlockSource blockSource;
    protected long blockStart;
    protected ChannelFactory<Seekable> channelFactory;

    public boolean hasNext() throws IOException {
        return this.blockSource.hasBlockAfter(this.blockStart);
    }

    public boolean hasPrev() throws IOException {
        return this.blockSource.hasBlockBefore(this.blockStart);
    }

    public Ref<? extends Block> nextBlock() throws IOException {
        return this.blockSource.contentAtOrAfter(this.blockStart, false);
    }

    public Ref<? extends Block> prevBlock() throws IOException {
        return this.blockSource.contentAtOrBefore(this.blockStart, false);
    }

    public long getOffset() {
        return this.blockStart;
    }

    public DecodedDataBlock(BlockSource blockSource, long blockStart, ChannelFactory<Seekable> channelFactory) {
        this.blockSource = blockSource;
        this.blockStart = blockStart;
        this.channelFactory = channelFactory;
    }

    public BlockSource getBufferSource() {
        return this.blockSource;
    }

    public long getBlockStart() {
        return this.blockStart;
    }

    public ChannelFactory<Seekable> getChannelFactory() {
        return this.channelFactory;
    }

    public Seekable newChannel() {
        return (Seekable)this.channelFactory.newChannel();
    }

    public void close() throws Exception {
        this.channelFactory.close();
    }

    public long length() throws IOException {
        long result = this.blockSource.getSizeOfBlock(this.blockStart);
        return result;
    }
}

