/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.bz2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.deprecated.MatcherFactory;
import org.aksw.commons.io.hadoop.SeekableInputStream;
import org.aksw.commons.io.hadoop.SeekableInputStreams;
import org.aksw.commons.io.hadoop.binseach.bz2.BufferOverInputStream;
import org.aksw.commons.io.hadoop.binseach.bz2.CharSequenceFromSeekable;
import org.aksw.commons.io.hadoop.binseach.bz2.DecodedDataBlock;
import org.aksw.commons.io.hadoop.binseach.bz2.ReverseCharSequenceFromSeekable;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.io.seekable.api.SeekableSource;
import org.aksw.commons.util.ref.Ref;
import org.aksw.commons.util.ref.RefImpl;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.io.compress.bzip2.CBZip2InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockSourceBzip2
implements BlockSource {
    private static final Logger logger = LoggerFactory.getLogger(BlockSourceBzip2.class);
    public static final String COMPRESSED_MAGIC_STR = "1AY&SY";
    public static final Pattern fwdMagicPattern = Pattern.compile("1AY&SY", 16);
    public static final Pattern bwdMagicPattern = Pattern.compile("YS&YA1", 16);
    public static final int MAX_SEARCH_RANGE = 1000000;
    protected SeekableSource seekableSource;
    public static long ABSENT = -1L;
    public static long UNKNOWN = -2L;
    protected LoadingCache<Long, Neighbour> blockTopologyCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<Long, Neighbour>(){

        public Neighbour load(Long key) throws Exception {
            return new Neighbour();
        }
    });
    protected Cache<Long, Ref<Block>> blockContentCache = CacheBuilder.newBuilder().removalListener(notification -> ((Ref)notification.getValue()).close()).build();
    protected long cachedBlockSize = UNKNOWN;
    protected long cachedLastBlockSize = UNKNOWN;

    public BlockSourceBzip2(SeekableSource seekableSource, MatcherFactory fwdBlockStartMatcherFactory, MatcherFactory bwdBlockStartMatcherFactory) {
        this.seekableSource = seekableSource;
    }

    public static BlockSource create(SeekableSource seekableSource) {
        if (!seekableSource.supportsAbsolutePosition()) {
            throw new RuntimeException("The seekable source must support absolution positions");
        }
        return new BlockSourceBzip2(seekableSource, null, null);
    }

    protected Ref<Block> loadBlock(Seekable seekable) throws IOException {
        Object effectiveIn;
        long blockStart = seekable.getPos();
        boolean useHadoop = false;
        if (!useHadoop) {
            InputStream rawIn = Channels.newInputStream((ReadableByteChannel)seekable);
            effectiveIn = new CBZip2InputStream(rawIn, SplittableCompressionCodec.READ_MODE.BYBLOCK){

                public int read(byte[] dest, int offs, int len) throws IOException {
                    int r = super.read(dest, offs, len);
                    if (r == -2) {
                        r = -1;
                    }
                    return r;
                }
            };
        } else {
            SeekableInputStream seekableIn = SeekableInputStreams.create(seekable, Seekable::getPos, Seekable::setPos);
            BZip2Codec codec = new BZip2Codec();
            SplitCompressionInputStream decodedIn = codec.createInputStream((InputStream)((Object)seekableIn), null, blockStart, Long.MAX_VALUE, SplittableCompressionCodec.READ_MODE.BYBLOCK);
            ReadableByteChannel wrapper = SeekableInputStreams.advertiseEndOfBlock((InputStream)decodedIn, -1);
            effectiveIn = Channels.newInputStream(wrapper);
        }
        BufferOverInputStream blockBuffer = new BufferOverInputStream(8192, (InputStream)effectiveIn);
        DecodedDataBlock block = new DecodedDataBlock(this, blockStart, blockBuffer);
        Ref result = RefImpl.create((Object)block, null, () -> block.close(), (Object)("Root ref to block " + blockStart));
        return result;
    }

    public long findBlockAtOrBeforeCached(Seekable seekable) throws IOException {
        long result;
        Neighbour n;
        long pos = seekable.getPos();
        try {
            n = (Neighbour)this.blockTopologyCache.get((Object)pos);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (n != null && n.prevBlockOffset >= ABSENT) {
            result = n.prevBlockOffset;
            if (result >= 0L) {
                seekable.setPos(result);
            }
        } else {
            n.prevBlockOffset = result = this.findBlockAtOrBefore(seekable);
        }
        return result;
    }

    public long findBlockAtOrBefore(Seekable seekable) throws IOException {
        long result;
        long internalRequestPos = seekable.getPos();
        int searchRangeLimit = Math.min(Ints.saturatedCast((long)(internalRequestPos + 1L)), 1000000);
        ReverseCharSequenceFromSeekable charSequence = new ReverseCharSequenceFromSeekable(seekable, 0, searchRangeLimit);
        Matcher matcher = bwdMagicPattern.matcher(charSequence);
        boolean didFind = matcher.find();
        if (didFind) {
            int end = matcher.end();
            result = seekable.getPos() - (long)(end - 1);
            seekable.setPos(result);
        } else {
            result = -1L;
        }
        return result;
    }

    public Ref<Block> contentAtOrBefore(long requestPos, boolean inclusive) throws IOException {
        logger.trace(String.format("contentAtOrBefore(%d, %b)", requestPos, inclusive));
        long internalRequestPos = requestPos - (long)(inclusive ? 0 : 1) + (long)(COMPRESSED_MAGIC_STR.length() - 1);
        Ref<Block> result = (Ref<Block>)this.blockContentCache.getIfPresent((Object)internalRequestPos);
        if (result == null) {
            Seekable seekable = this.seekableSource.get(internalRequestPos);
            long blockStart = this.findBlockAtOrBeforeCached(seekable);
            if (blockStart >= 0L) {
                result = this.cache(blockStart, seekable);
            } else {
                seekable.close();
            }
        }
        return result == null ? null : result.acquire(null);
    }

    public long findBlockAtOrAfterCached(Seekable seekable) throws IOException {
        long result;
        Neighbour n;
        long pos = seekable.getPos();
        try {
            n = (Neighbour)this.blockTopologyCache.get((Object)pos);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (n != null && n.nextBlockOffset >= ABSENT) {
            result = n.nextBlockOffset;
            if (result >= 0L) {
                seekable.setPos(result);
            }
        } else {
            n.nextBlockOffset = result = this.findBlockAtOrAfter(seekable);
        }
        return result;
    }

    public long findBlockAtOrAfter(Seekable seekable) throws IOException {
        long result;
        long internalRequestPos = seekable.getPos();
        int searchRangeLimit = Math.min(Ints.saturatedCast((long)(this.seekableSource.size() - internalRequestPos)), 1000000);
        CharSequenceFromSeekable charSequence = new CharSequenceFromSeekable(seekable, 0, searchRangeLimit);
        Matcher matcher = fwdMagicPattern.matcher(charSequence);
        boolean didFind = matcher.find();
        if (didFind) {
            result = seekable.getPos() + (long)matcher.start();
            seekable.setPos(result);
        } else {
            result = -1L;
        }
        return result;
    }

    public Ref<Block> contentAtOrAfter(long requestPos, boolean inclusive) throws IOException {
        logger.trace(String.format("contentAtOrAfter(%d, %b)", requestPos, inclusive));
        long internalRequestPos = requestPos + (long)(inclusive ? 0 : 1);
        Ref<Block> result = (Ref<Block>)this.blockContentCache.getIfPresent((Object)internalRequestPos);
        if (result == null) {
            Seekable seekable = this.seekableSource.get(internalRequestPos);
            long blockStart = this.findBlockAtOrAfterCached(seekable);
            if (blockStart >= 0L) {
                result = this.cache(blockStart, seekable);
            } else {
                seekable.close();
            }
        }
        return result == null ? null : result.acquire(null);
    }

    public boolean hasBlockAfter(long pos) throws IOException {
        boolean result;
        try (Seekable seekable = this.seekableSource.get(pos + 1L);){
            result = this.findBlockAtOrAfterCached(seekable) >= 0L;
        }
        return result;
    }

    public boolean hasBlockBefore(long pos) throws IOException {
        boolean result;
        long internalRequestPos = pos - 1L + (long)(COMPRESSED_MAGIC_STR.length() - 1);
        try (Seekable seekable = this.seekableSource.get(internalRequestPos);){
            result = this.findBlockAtOrBeforeCached(seekable) >= 0L;
        }
        return result;
    }

    public long size() throws IOException {
        long result = this.seekableSource.size();
        return result;
    }

    public Ref<Block> cache(long blockStart, Seekable seekable) throws IOException {
        Ref result;
        try {
            boolean[] usedLoader = new boolean[]{false};
            result = (Ref)this.blockContentCache.get((Object)blockStart, () -> {
                usedLoader[0] = true;
                return this.loadBlock(seekable);
            });
            if (!usedLoader[0]) {
                seekable.close();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public long getSizeOfBlock(long pos) throws IOException {
        return this.loadBlock(pos);
    }

    public long getSizeOfBlockCached(long pos) throws IOException {
        long result;
        boolean isLastBlock;
        try (Seekable seekable = this.seekableSource.get(pos + 1L);){
            isLastBlock = this.findBlockAtOrAfterCached(seekable) < 0L;
        }
        if (isLastBlock) {
            if (this.cachedLastBlockSize < 0L) {
                result = this.loadBlock(pos);
                if (this.cachedLastBlockSize != ABSENT) {
                    this.cachedLastBlockSize = result;
                }
            } else {
                result = this.cachedLastBlockSize;
            }
        } else if (this.cachedBlockSize < 0L) {
            result = this.loadBlock(pos);
            if (this.cachedBlockSize != ABSENT) {
                this.cachedBlockSize = result;
            }
        } else {
            result = this.cachedBlockSize;
        }
        return result;
    }

    protected long loadBlock(long pos) throws IOException {
        long result;
        try (Ref<Block> ref = this.contentAtOrAfter(pos, true);
             Seekable channel = (Seekable)((Block)ref.get()).newChannel();){
            result = ((BufferOverInputStream.ByteArrayChannel)channel).loadAll();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return result;
    }

    static class Neighbour {
        long prevBlockOffset = UNKNOWN;
        long nextBlockOffset = UNKNOWN;

        Neighbour() {
        }
    }
}

