/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.bz2;

import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.aksw.commons.io.binseach.BinSearchScanState;
import org.aksw.commons.io.binseach.BinarySearchOnSortedFile;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.block.api.Block;
import org.aksw.commons.io.block.api.BlockSource;
import org.aksw.commons.io.block.impl.BlockIterState;
import org.aksw.commons.io.hadoop.binseach.bz2.BlockSources;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.io.seekable.impl.SeekableFromBlock;
import org.aksw.commons.util.ref.Ref;

public class BinarySearchOnBlockSource
implements BinarySearcher {
    protected BlockSource blockSource;
    protected AutoCloseable closeAction;

    public BinarySearchOnBlockSource(BlockSource blockSource, AutoCloseable closeAction) {
        this.blockSource = blockSource;
        this.closeAction = closeAction;
    }

    public InputStream search(byte[] prefix) throws IOException {
        InputStream result;
        Ref<? extends Block> blockRef;
        if (prefix == null || prefix.length == 0) {
            blockRef = this.blockSource.contentAtOrAfter(0L, true);
        } else {
            long maxBlockOffset = this.blockSource.size();
            blockRef = BlockSources.binarySearch(this.blockSource, 0L, maxBlockOffset, (byte)10, prefix);
        }
        if (blockRef == null) {
            result = new ByteArrayInputStream(new byte[0]);
        } else {
            Block block = (Block)blockRef.get();
            int extraBytes = 0;
            BlockIterState it = BlockIterState.fwd((boolean)true, (Ref)blockRef.acquire(), (boolean)false);
            while (it.hasNext()) {
                it.advance();
                try (SeekableFromBlock seekable = new SeekableFromBlock(it.blockRef.acquire(), 0, 0L);){
                    boolean found = seekable.posToNext((byte)10);
                    if (!found) continue;
                    extraBytes = Ints.checkedCast((long)seekable.getPos());
                    it.closeCurrent();
                    break;
                }
            }
            it.closeCurrent();
            long blockSize = block.length();
            long maxPos = blockSize + (long)extraBytes;
            SeekableFromBlock decodedView = new SeekableFromBlock(blockRef, 0, 0L, Long.MIN_VALUE, maxPos);
            if (prefix == null || prefix.length == 0) {
                decodedView.setPos(0L);
                result = Channels.newInputStream((ReadableByteChannel)decodedView);
            } else {
                long findPos = decodedView.binarySearch(-1L, maxPos, (byte)10, prefix);
                if (findPos == Long.MIN_VALUE) {
                    result = new ByteArrayInputStream(new byte[0]);
                } else {
                    long start = BinarySearchOnSortedFile.getPosOfFirstMatch((Seekable)decodedView, (byte)10, (byte[])prefix);
                    decodedView.nextPos(1);
                    BinSearchScanState state = new BinSearchScanState();
                    state.firstDelimPos = start;
                    state.matchDelimPos = findPos;
                    state.prefixBytes = prefix;
                    state.size = Long.MAX_VALUE;
                    result = BinarySearchOnSortedFile.newInputStream((Seekable)decodedView, (BinSearchScanState)state);
                }
            }
        }
        return result;
    }

    public void close() throws Exception {
        if (this.closeAction != null) {
            this.closeAction.close();
        }
    }
}

