/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.NavigableMap;
import net.sansa_stack.nio.util.SeekableByteChannelDecorator;

public class SeekableReadableChannelWithBlockTracking<T extends SeekableByteChannel>
implements SeekableByteChannelDecorator {
    protected T delegate;
    protected int endOfBlockMarker;
    protected long currentBlock = -1L;
    protected NavigableMap<Long, Long> blockToSuccessor;

    public SeekableReadableChannelWithBlockTracking(T delegate, int endOfBlockMarker) {
        this.delegate = delegate;
        this.endOfBlockMarker = endOfBlockMarker;
    }

    public SeekableByteChannel getDecoratee() {
        return this.delegate;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int result = this.delegate.read(byteBuffer);
        if (result == this.endOfBlockMarker) {
            long pos = this.delegate.position();
            if (this.currentBlock != -1L) {
                this.blockToSuccessor.put(this.currentBlock, pos);
                this.currentBlock = pos;
            }
        }
        return result;
    }

    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel position(long newPosition) throws IOException {
        Long blockStart = this.blockToSuccessor.floorKey(newPosition);
        if (blockStart == null) {
            this.currentBlock = -1L;
            this.delegate.position(newPosition);
        } else {
            this.currentBlock = blockStart;
            this.delegate.position(blockStart);
        }
        return this;
    }
}

