/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.hadoop.SeekableInputStream;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelBase;
import org.aksw.commons.io.util.channel.ReadableByteChannelDecoratorBase;
import org.apache.hadoop.fs.Seekable;

public class SeekableInputStreams {
    public static Seekable createSeekable(final GetPosition getPosition, final SetPosition setPosition) {
        return new Seekable(){

            public void seek(long pos) throws IOException {
                setPosition.accept(pos);
            }

            public long getPos() throws IOException {
                return getPosition.call();
            }

            public boolean seekToNewSource(long targetPos) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T extends ReadableByteChannel> SeekableInputStream create(T channel, GetPositionFn<? super T> getPosition, SetPositionFn<? super T> setPosition) {
        return SeekableInputStreams.create(Channels.newInputStream(channel), () -> getPosition.apply((Object)channel), (long position) -> setPosition.apply((Object)channel, position));
    }

    public static SeekableReadableChannel<byte[]> wrap(final SeekableInputStream in) {
        Objects.requireNonNull(in);
        return new SeekableReadableChannelBase<byte[]>(){

            public SeekableReadableChannel<byte[]> cloneObject() {
                throw new UnsupportedOperationException();
            }

            public int read(byte[] array, int position, int length) throws IOException {
                return in.read(array, position, length);
            }

            public ArrayOps<byte[]> getArrayOps() {
                return ArrayOps.BYTE;
            }

            public long position() {
                return in.position();
            }

            public void position(long pos) {
                in.position(pos);
            }

            protected void closeActual() throws Exception {
                in.close();
            }
        };
    }

    public static <T extends ReadableByteChannel> SeekableInputStream create(InputStream in, GetPosition getPosition, SetPosition setPosition) {
        Seekable seekable = SeekableInputStreams.createSeekable(getPosition, setPosition);
        return new SeekableInputStream(in, seekable);
    }

    public static SeekableInputStream create(InputStream in, Seekable seekable) {
        return new SeekableInputStream(in, seekable);
    }

    public static ReadableByteChannel advertiseEndOfBlock(InputStream decodedIn, final int endOfBlockMarker) throws IOException {
        final Seekable s = (Seekable)decodedIn;
        final long[] decodedStartPos = new long[]{s.getPos()};
        final PushbackInputStream pushbackIn = new PushbackInputStream(decodedIn, 1);
        ReadableByteChannelDecoratorBase<ReadableByteChannel> wrapper = new ReadableByteChannelDecoratorBase<ReadableByteChannel>(Channels.newChannel(pushbackIn)){

            public int read(ByteBuffer byteBuffer) throws IOException {
                int backupPos = byteBuffer.position();
                byte before = byteBuffer.get(backupPos);
                int result = super.read(byteBuffer);
                if (result == 1) {
                    boolean change;
                    long decodedPos = s.getPos();
                    boolean bl = change = decodedStartPos[0] != decodedPos;
                    if (change) {
                        byte after = byteBuffer.get(backupPos);
                        pushbackIn.unread(after);
                        byteBuffer.put(backupPos, before);
                        byteBuffer.position(backupPos);
                        decodedStartPos[0] = decodedPos;
                        result = endOfBlockMarker;
                    }
                }
                return result;
            }
        };
        return wrapper;
    }

    public static interface SetPositionFn<T> {
        public void apply(T var1, long var2) throws IOException;
    }

    public static interface GetPositionFn<T> {
        public long apply(T var1) throws IOException;
    }

    public static interface SetPosition {
        public void accept(long var1) throws IOException;
    }

    public static interface GetPosition {
        public long call() throws IOException;
    }
}

