/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import org.aksw.commons.io.hadoop.binseach.bz2.ReadableByteChannelBase;
import org.apache.hadoop.fs.Seekable;

public class ReadableChannelWithBlockAdvertisement
extends ReadableByteChannelBase {
    protected InputStream decodedIn;
    protected Seekable seekable;
    protected long decodedStartPos;
    protected PushbackInputStream pushbackIn;
    protected long readCount = 0L;

    public ReadableChannelWithBlockAdvertisement(InputStream decodedIn) {
        this.seekable = (Seekable)decodedIn;
        try {
            this.decodedStartPos = this.seekable.getPos();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.pushbackIn = new PushbackInputStream(decodedIn, 1);
    }

    @Override
    protected int readActual(ByteBuffer dst) throws IOException {
        int backupPos = dst.position();
        byte before = dst.get(backupPos);
        int result = super.read(dst);
        if (result > 0) {
            this.readCount += (long)result;
        }
        if (result == 1) {
            boolean change;
            long decodedPos = this.seekable.getPos();
            boolean bl = change = this.decodedStartPos != decodedPos;
            if (change) {
                byte after = dst.get(backupPos);
                this.pushbackIn.unread(after);
                dst.put(backupPos, before);
                dst.position(backupPos);
                result = this.onBlockEnd(dst, this.decodedStartPos, decodedPos);
                this.decodedStartPos = decodedPos;
            }
        }
        return result;
    }

    protected int onBlockEnd(ByteBuffer dst, long oldPos, long newPos) {
        return -2;
    }
}

