/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.util;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.aksw.commons.index.util.CSet;
import org.aksw.commons.index.util.CSetImpl;
import org.aksw.commons.index.util.CSetSupplier;
import org.aksw.commons.index.util.SetSupplier;

public class SetSuppliers {
    public static <X> CSetSupplier<X> wrapAsCSet(final SetSupplier setSupplier, final Supplier<X> valueSupplier) {
        return new CSetSupplier<X>(){

            @Override
            public <T> CSet<T, X> get() {
                Set tmp = setSupplier.get();
                return new CSetImpl(tmp, valueSupplier.get());
            }
        };
    }

    public static SetSupplier none() {
        return new SetSupplier(){

            public <V> Set<V> get() {
                return null;
            }
        };
    }

    public static SetSupplier forceCast(final Supplier<Set<?>> setSupplier) {
        return new SetSupplier(){

            public <V> Set<V> get() {
                return (Set)setSupplier.get();
            }
        };
    }

    public static <X> SetSupplier forTreeSet(Comparator<X> cmp) {
        return new SetSupplierTreeSet<X>(cmp);
    }

    public static class SetSupplierTreeSet<X>
    implements SetSupplier {
        protected Comparator<X> cmp;

        public SetSupplierTreeSet(Comparator<X> cmp) {
            this.cmp = cmp;
        }

        @Override
        public <T> Set<T> get() {
            return new TreeSet<X>(this.cmp);
        }
    }
}

