/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.util;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.aksw.commons.index.util.CMap;
import org.aksw.commons.index.util.CMapImpl;
import org.aksw.commons.index.util.CMapSupplier;
import org.aksw.commons.index.util.MapSupplier;

public class MapSuppliers {
    public static <X> CMapSupplier<X> wrapAsCMap(final MapSupplier supp, final Supplier<X> initValueSupp) {
        return new CMapSupplier<X>(){

            @Override
            public <K, V> CMap<K, V, X> get() {
                Object data = initValueSupp.get();
                Map core = supp.get();
                return new CMapImpl(core, data);
            }
        };
    }

    public static <T> MapSupplier forTreeMap(Comparator<T> cmp) {
        return new MapSupplierTreeMap<T>(cmp);
    }

    public static class MapSupplierTreeMap<T>
    implements MapSupplier {
        protected Comparator<T> cmp;

        public MapSupplierTreeMap(Comparator<T> cmp) {
            this.cmp = cmp;
        }

        @Override
        public <K, V> Map<K, V> get() {
            return new TreeMap(this.cmp);
        }
    }
}

