/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNodeBase;
import org.aksw.commons.index.core.StorageNodeMutable;
import org.aksw.commons.index.util.MapSupplier;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.accessor.TupleAccessor;
import org.aksw.commons.tuple.bridge.TupleBridge;
import org.aksw.commons.util.stream.Streamer;

abstract class StorageNodeMapBase<D, C, K, V, M extends Map<K, V>>
extends StorageNodeBase<D, C, M>
implements StorageNodeMutable<D, C, M> {
    protected MapSupplier mapSupplier;
    protected TupleValueFunction<C, K> keyFunction;
    protected TupleAccessor<? super K, ? extends C> keyToComponent;

    public K tupleToKey(D tupleLike) {
        K result = this.keyFunction.map(tupleLike, (d, i) -> this.tupleAccessor.get(d, this.tupleIdxs[i]));
        return result;
    }

    public StorageNodeMapBase(int[] tupleIdxs, TupleBridge<D, C> tupleAccessor, MapSupplier mapSupplier, TupleValueFunction<C, K> keyFunction, TupleAccessor<? super K, ? extends C> keyToComponent) {
        super(tupleIdxs, tupleAccessor);
        this.mapSupplier = mapSupplier;
        this.keyFunction = keyFunction;
        this.keyToComponent = keyToComponent;
    }

    @Override
    public boolean isMapNode() {
        return true;
    }

    public M getStoreAsMap(Object store) {
        return (M)((Map)store);
    }

    @Override
    public M newStore() {
        return (M)this.mapSupplier.get();
    }

    @Override
    public boolean isEmpty(M map) {
        boolean result = map.isEmpty();
        return result;
    }

    public static <T, C> Object[] projectTupleToArray(int[] tupleIdxs, T tupleLike, TupleAccessor<T, C> tupleAccessor) {
        Object[] result = new Object[tupleIdxs.length];
        for (int i = 0; i < tupleIdxs.length; ++i) {
            Object componentValue = tupleAccessor.get(tupleLike, tupleIdxs[i]);
            if (componentValue == null) {
                result = null;
                break;
            }
            result[i] = componentValue;
        }
        return result;
    }

    public <T> Streamer<M, K> streamerForKeysUnderConstraints(T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        Streamer result;
        Object[] keyComponents = StorageNodeMapBase.projectTupleToArray(this.tupleIdxs, tupleLike, tupleAccessor);
        if (keyComponents != null) {
            Object key = this.keyFunction.map(keyComponents, (x, i) -> x[i]);
            result = argMap -> argMap.containsKey(key) ? Stream.of(key) : Stream.empty();
        } else {
            result = argMap -> argMap.keySet().stream();
        }
        return result;
    }

    public <T> Streamer<M, V> streamerForValuesUnderConstraints(T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        Streamer result;
        Object[] keyComponents = StorageNodeMapBase.projectTupleToArray(this.tupleIdxs, tupleLike, tupleAccessor);
        if (keyComponents != null) {
            Object key = this.keyFunction.map(keyComponents, (x, i) -> x[i]);
            result = argMap -> argMap.containsKey(key) ? Stream.of(argMap.get(key)) : Stream.empty();
        } else {
            result = argMap -> argMap.values().stream();
        }
        return result;
    }

    public <T> Streamer<M, Map.Entry<K, V>> streamerForEntriesUnderConstraints(T tupleLike, TupleAccessor<? super T, ? extends C> tupleAccessor) {
        Streamer result;
        Object[] tmp = new Object[this.tupleIdxs.length];
        boolean eligibleAsKey = true;
        for (int i2 = 0; i2 < this.tupleIdxs.length; ++i2) {
            Object componentValue = tupleAccessor.get(tupleLike, this.tupleIdxs[i2]);
            if (componentValue == null) {
                eligibleAsKey = false;
                break;
            }
            tmp[i2] = componentValue;
        }
        if (eligibleAsKey) {
            Object key = this.keyFunction.map(tmp, (x, i) -> x[i]);
            result = argMap -> argMap.containsKey(key) ? Stream.of(Maps.immutableEntry((Object)key, argMap.get(key))) : Stream.empty();
        } else {
            result = argMap -> argMap.entrySet().stream();
        }
        return result;
    }

    @Override
    public <T> Streamer<M, C> streamerForKeysAsComponent(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        Streamer baseStreamer = this.streamerForKeysUnderConstraints(pattern, accessor);
        return argMap -> baseStreamer.stream(argMap).map(key -> key);
    }

    @Override
    public <T> Streamer<M, V> streamerForValues(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return this.streamerForValuesUnderConstraints(pattern, accessor);
    }

    @Override
    public <T> Streamer<M, List<C>> streamerForKeysAsTuples(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return null;
    }

    @Override
    public <T> Streamer<M, K> streamerForKeys(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return this.streamerForKeysUnderConstraints(pattern, accessor);
    }

    @Override
    public <T> Streamer<M, Map.Entry<K, V>> streamerForKeyAndSubStoreAlts(T pattern, TupleAccessor<? super T, ? extends C> accessor) {
        return this.streamerForEntriesUnderConstraints(pattern, accessor);
    }

    @Override
    public C getKeyComponentRaw(Object key, int idx) {
        Object result = this.keyToComponent.get(key, idx);
        return (C)result;
    }

    public C getKeyComponent(K key, int idx) {
        Object result = this.keyToComponent.get(key, idx);
        return (C)result;
    }

    @Override
    public Object chooseSubStore(M store, int subStoreIdx) {
        if (subStoreIdx != 0) {
            throw new IndexOutOfBoundsException("Index must be 0 for inner maps");
        }
        return store;
    }
}

