/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeSetBase;
import org.aksw.commons.index.util.SetSupplier;
import org.aksw.commons.index.util.Streamer;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.TupleAccessor;
import org.aksw.commons.tuple.TupleAccessorCore;

public class StorageNodeLeafDomainSet<D, C, V, S extends Set<V>>
extends StorageNodeSetBase<D, C, V, S> {
    protected TupleValueFunction<C, V> valueFunction;

    public StorageNodeLeafDomainSet(TupleAccessor<D, C> tupleAccessor, SetSupplier setSupplier, TupleValueFunction<C, V> valueFunction) {
        super(new int[0], tupleAccessor, setSupplier);
        this.valueFunction = valueFunction;
    }

    @Override
    public boolean holdsDomainTuples() {
        return true;
    }

    public V tupleToValue(D tupleLike) {
        V result = this.valueFunction.map(tupleLike, (d, i) -> this.tupleAccessor.get(d, this.tupleIdxs[i]));
        return result;
    }

    @Override
    public List<StorageNode<D, C, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean add(S set, D tupleLike) {
        V newValue = this.tupleToValue(tupleLike);
        boolean result = set != null ? set.add(newValue) : false;
        return result;
    }

    @Override
    public boolean remove(S set, D tupleLike) {
        V newValue = this.tupleToValue(tupleLike);
        boolean result = set.remove(newValue);
        return result;
    }

    @Override
    public void clear(S store) {
        store.clear();
    }

    public String toString() {
        return "(" + Arrays.toString(this.tupleIdxs) + ")";
    }

    @Override
    public <T> Streamer<S, C> streamerForKeysAsComponent(T pattern, TupleAccessorCore<? super T, ? extends C> accessor) {
        throw new UnsupportedOperationException("Cannot stream keys as components if there are no keys");
    }

    @Override
    public <T> Streamer<S, List<C>> streamerForKeysAsTuples(T pattern, TupleAccessorCore<? super T, ? extends C> accessor) {
        return argStore -> Stream.of(Collections.emptyList());
    }

    @Override
    public <T> Streamer<S, V> streamerForValues(T pattern, TupleAccessorCore<? super T, ? extends C> accessor) {
        return argSet -> argSet.stream();
    }

    @Override
    public <T> Streamer<S, ? extends Map.Entry<?, ?>> streamerForKeyAndSubStoreAlts(T pattern, TupleAccessorCore<? super T, ? extends C> accessor) {
        return argSet -> Stream.of(Maps.immutableEntry(Collections.emptyList(), (Object)argSet));
    }

    @Override
    public <T> Stream<V> streamEntries(S set, T tupleLike, TupleAccessorCore<? super T, ? extends C> tupleAccessor) {
        return set.stream();
    }

    @Override
    public <T> Streamer<S, ?> streamerForKeys(T pattern, TupleAccessorCore<? super T, ? extends C> accessor) {
        return null;
    }

    @Override
    public C getKeyComponentRaw(Object key, int idx) {
        throw new RuntimeException("Key is an empty tuple - there are no key components");
    }

    @Override
    public Object chooseSubStore(S store, int subStoreIdx) {
        if (subStoreIdx != 0) {
            throw new IndexOutOfBoundsException("Index must be 0 for leaf maps");
        }
        return store;
    }
}

