/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeMapBase;
import org.aksw.commons.index.core.StorageNodeMutable;
import org.aksw.commons.index.util.MapSupplier;
import org.aksw.commons.index.util.TupleValueFunction;
import org.aksw.commons.tuple.TupleAccessor;
import org.aksw.commons.tuple.TupleAccessorCore;

public class StorageNodeInnerMap<D, C, K, V, M extends Map<K, V>>
extends StorageNodeMapBase<D, C, K, V, M> {
    protected StorageNodeMutable<D, C, V> child;

    public StorageNodeInnerMap(int[] tupleIdxs, TupleAccessor<D, C> tupleAccessor, StorageNodeMutable<D, C, V> child, MapSupplier mapSupplier, TupleValueFunction<C, K> keyFunction, TupleAccessorCore<? super K, ? extends C> keyToComponent) {
        super(tupleIdxs, tupleAccessor, mapSupplier, keyFunction, keyToComponent);
        this.child = child;
    }

    @Override
    public List<StorageNode<D, C, ?>> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public M newStore() {
        return (M)this.mapSupplier.get();
    }

    @Override
    public boolean add(M map, D tupleLike) {
        Object key = this.tupleToKey((Object)tupleLike);
        Object v = map.get(key);
        if (v == null) {
            v = this.child.newStore();
            map.put((Object)key, v);
        }
        boolean result = this.child.add(v, tupleLike);
        return result;
    }

    @Override
    public boolean remove(M map, D tupleLike) {
        Object key = this.tupleToKey((Object)tupleLike);
        boolean result = false;
        Object v = map.get(key);
        if (v != null) {
            result = this.child.remove(v, tupleLike);
            if (this.child.isEmpty(v)) {
                map.remove(key);
            }
        }
        return result;
    }

    @Override
    public void clear(M store) {
        for (Object subStoreAlts : store.values()) {
            this.child.clear(subStoreAlts);
        }
        store.clear();
    }

    public String toString() {
        return "innerMap(" + Arrays.toString(this.tupleIdxs) + " -> " + Objects.toString(this.child) + ")";
    }

    @Override
    public <T> Stream<Map.Entry<K, ?>> streamEntries(M map, T tupleLike, TupleAccessorCore<? super T, ? extends C> tupleAccessor) {
        Object key;
        Object childStore;
        Object[] tmp = new Object[this.tupleIdxs.length];
        boolean eligibleAsKey = true;
        for (int i2 = 0; i2 < this.tupleIdxs.length; ++i2) {
            Object componentValue = tupleAccessor.get(tupleLike, i2);
            if (componentValue == null) {
                eligibleAsKey = false;
                break;
            }
            tmp[i2] = componentValue;
        }
        Stream<Object> childStream = eligibleAsKey ? ((childStore = map.get(key = this.keyFunction.map(tmp, (x, i) -> x[i]))) == null ? Stream.empty() : this.child.streamEntries(childStore, tupleLike, tupleAccessor).map(v -> new AbstractMap.SimpleEntry<Object, Object>(key, v))) : map.entrySet().stream().flatMap(e -> this.child.streamEntries(e.getValue(), tupleLike, tupleAccessor).map(v -> new AbstractMap.SimpleEntry(e.getKey(), v)));
        return childStream;
    }
}

