/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.commons.index.core.StorageNode;
import org.aksw.commons.index.core.StorageNodeMutable;
import org.aksw.commons.index.util.Streamer;
import org.aksw.commons.tuple.TupleAccessor;
import org.aksw.commons.tuple.TupleAccessorCore;

public class StorageNodeDictionary<D1, C1, D2, C2, V, X extends StorageNodeMutable<D2, C2, V>>
implements StorageNodeMutable<D1, C1, V> {
    protected X delegate;
    protected BiMap<C1, C2> dictionary;
    protected TupleAccessor<D1, C1> sourceTupleAccessor;
    protected TupleAccessor<D2, C2> targetTupleAccessor;

    public StorageNodeDictionary(X delegate, BiMap<C1, C2> dictionary, TupleAccessor<D1, C1> sourceTupleAccessor, TupleAccessor<D2, C2> targetTupleAccessor) {
        this.delegate = delegate;
        this.dictionary = dictionary;
        this.sourceTupleAccessor = sourceTupleAccessor;
        this.targetTupleAccessor = targetTupleAccessor;
    }

    protected C2 makeEntry(C1 c1) {
        return null;
    }

    public D2 mapSourceToTarget(D1 sourceTuple) {
        Object result = this.targetTupleAccessor.restore(sourceTuple, (st, i) -> {
            Object c1 = this.sourceTupleAccessor.get(st, i);
            Object c2 = this.dictionary.computeIfAbsent(c1, c -> this.makeEntry(c));
            return c2;
        });
        return (D2)result;
    }

    public D1 mapTargetToSource(D2 targetTuple) {
        Object result = this.sourceTupleAccessor.restore(targetTuple, (tt, i) -> {
            Object c2 = this.targetTupleAccessor.get(tt, i);
            Object c1 = this.dictionary.inverse().get(c2);
            return c1;
        });
        return (D1)result;
    }

    @Override
    public boolean add(V store, D1 sourceTuple) {
        D2 targetTuple = this.mapSourceToTarget(sourceTuple);
        return this.delegate.add(store, targetTuple);
    }

    @Override
    public boolean remove(V store, D1 sourceTuple) {
        D2 targetTuple = this.mapSourceToTarget(sourceTuple);
        return this.delegate.remove(store, targetTuple);
    }

    @Override
    public void clear(V store) {
        this.delegate.clear(store);
    }

    @Override
    public V newStore() {
        return this.delegate.newStore();
    }

    @Override
    public boolean isEmpty(V store) {
        return this.delegate.isEmpty(store);
    }

    @Override
    public List<? extends StorageNode<D1, C1, ?>> getChildren() {
        return null;
    }

    @Override
    public int[] getKeyTupleIdxs() {
        return this.delegate.getKeyTupleIdxs();
    }

    @Override
    public TupleAccessor<D1, C1> getTupleAccessor() {
        return this.sourceTupleAccessor;
    }

    @Override
    public <T> Streamer<V, C1> streamerForKeysAsComponent(T pattern, TupleAccessorCore<? super T, ? extends C1> accessor) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <T> Streamer<V, List<C1>> streamerForKeysAsTuples(T pattern, TupleAccessorCore<? super T, ? extends C1> accessor) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <T> Streamer<V, ?> streamerForKeys(T pattern, TupleAccessorCore<? super T, ? extends C1> accessor) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public C1 getKeyComponentRaw(Object key, int idx) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Object chooseSubStore(V store, int subStoreIdx) {
        return store;
    }

    @Override
    public <T> Streamer<V, ?> streamerForValues(T pattern, TupleAccessorCore<? super T, ? extends C1> accessor) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <T> Streamer<V, ? extends Map.Entry<?, ?>> streamerForKeyAndSubStoreAlts(T pattern, TupleAccessorCore<? super T, ? extends C1> accessor) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <T> Stream<?> streamEntries(V store, T tupleLike, TupleAccessorCore<? super T, ? extends C1> tupleAccessor) {
        throw new UnsupportedOperationException("not implemented");
    }
}

