/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.commons.index.util.Streamer;
import org.aksw.commons.tuple.TupleAccessor;
import org.aksw.commons.tuple.TupleAccessorCore;

public interface StorageNode<D, C, V> {
    public List<? extends StorageNode<D, C, ?>> getChildren();

    default public boolean isDelegate() {
        return false;
    }

    default public StorageNode<D, C, V> getPublicDelegate() {
        return null;
    }

    default public boolean isAltNode() {
        return false;
    }

    default public boolean isSetNode() {
        return false;
    }

    default public boolean isListNode() {
        return false;
    }

    default public boolean isMapNode() {
        return false;
    }

    default public boolean holdsDomainTuples() {
        return false;
    }

    default public Map<?, ?> getStoreAsMap(Object store) {
        throw new UnsupportedOperationException("Not a map storage node; storage node type is " + this.getClass());
    }

    default public List<?> getStoreAsList(Object store) {
        throw new UnsupportedOperationException("Not a list storage node; storage node type is " + this.getClass());
    }

    default public Set<?> getStoreAsSet(Object store) {
        throw new UnsupportedOperationException("Not a set storage node; storage node type is " + this.getClass());
    }

    public int[] getKeyTupleIdxs();

    public TupleAccessor<D, C> getTupleAccessor();

    public <T> Streamer<V, C> streamerForKeysAsComponent(T var1, TupleAccessorCore<? super T, ? extends C> var2);

    public <T> Streamer<V, List<C>> streamerForKeysAsTuples(T var1, TupleAccessorCore<? super T, ? extends C> var2);

    public <T> Streamer<V, ?> streamerForKeys(T var1, TupleAccessorCore<? super T, ? extends C> var2);

    public C getKeyComponentRaw(Object var1, int var2);

    public Object chooseSubStore(V var1, int var2);

    default public Object chooseSubStoreRaw(Object store, int subStoreIdx) {
        Object result = this.chooseSubStore(store, subStoreIdx);
        return result;
    }

    public <T> Streamer<V, ?> streamerForValues(T var1, TupleAccessorCore<? super T, ? extends C> var2);

    public <T> Streamer<V, ? extends Map.Entry<?, ?>> streamerForKeyAndSubStoreAlts(T var1, TupleAccessorCore<? super T, ? extends C> var2);

    public <T> Stream<?> streamEntries(V var1, T var2, TupleAccessorCore<? super T, ? extends C> var3);

    default public <T> Stream<?> streamEntriesRaw(Object store, T tupleLike, TupleAccessorCore<? super T, ? extends C> tupleAccessor) {
        return this.streamEntries(store, tupleLike, tupleAccessor);
    }

    default public Stream<?> streamEntriesRaw(Object store) {
        return this.streamEntries(store);
    }

    default public Stream<?> streamEntries(V store) {
        return this.streamEntriesRaw(store, null, (x, i) -> null);
    }
}

