/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.index;

import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.index.TupleCodec;
import org.aksw.commons.tuple.TupleAccessor;

public abstract class TupleCodecCanonical<D, C>
implements TupleCodec<D, C, D, C> {
    protected Map<C, C> canonicalMap = new HashMap<C, C>();
    protected TupleAccessor<D, C> tupleAccessor;

    public TupleCodecCanonical(TupleAccessor<D, C> tupleAccessor) {
        this.tupleAccessor = tupleAccessor;
    }

    protected abstract C makeEntry(C var1);

    public static <D, C> TupleCodec<D, C, D, C> create(TupleAccessor<D, C> tupleAccessor) {
        return new TupleCodecCanonical<D, C>((TupleAccessor)tupleAccessor){

            @Override
            protected C makeEntry(C c1) {
                this.canonicalMap.put(c1, c1);
                return c1;
            }
        };
    }

    @Override
    public C getEncodedComponent(D d1, int idx) {
        Object c1 = this.tupleAccessor.get(d1, idx);
        Object result = this.encodeComponent((C)c1);
        return (C)result;
    }

    @Override
    public C getDecodedComponent(D d, int idx) {
        Object c2 = this.tupleAccessor.get(d, idx);
        return (C)c2;
    }

    @Override
    public TupleAccessor<D, C> getSourceTupleAccessor() {
        return this.tupleAccessor;
    }

    @Override
    public TupleAccessor<D, C> getTargetTupleAccessor() {
        return this.tupleAccessor;
    }

    @Override
    public C encodeComponent(C c1) {
        Object result = this.canonicalMap.computeIfAbsent(c1, c -> this.makeEntry(c));
        return (C)result;
    }

    @Override
    public C decodeComponent(C c2) {
        return c2;
    }

    @Override
    public D encodeTuple(D sourceTuple) {
        Object result = this.tupleAccessor.restore(sourceTuple, (st, i) -> {
            Object c1 = this.tupleAccessor.get(st, i);
            Object c2 = this.encodeComponent((C)c1);
            return c2;
        });
        return (D)result;
    }

    @Override
    public D decodeTuple(D targetTuple) {
        return targetTuple;
    }
}

