/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aksw.commons.collections.multimaps.MultimapUtils;
import org.aksw.commons.collections.trees.SubTree;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeImpl;
import org.aksw.commons.collections.trees.TreeOps2;
import org.aksw.commons.collections.trees.TreeReplace;

public class TreeUtils {
    public static <T> Multimap<T, T> groupByParent(Tree<T> tree, Collection<T> nodes, Multimap<T, T> result) {
        MultimapUtils.groupBy(nodes, tree::getParent, result);
        return result;
    }

    public static <T> Set<T> propagateBottomUpLabel(Tree<T> tree, Predicate<T> predicate) {
        boolean anyMatch;
        List<T> leafs = TreeUtils.getLeafs(tree);
        Set result = leafs.stream().filter(predicate).collect(Collectors.toCollection(Sets::newIdentityHashSet));
        do {
            Set parents = result.stream().map(tree::getParent).filter(x -> x != null).collect(Collectors.toCollection(Sets::newIdentityHashSet));
            anyMatch = false;
            for (Object parent : parents) {
                Collection<T> children = tree.getChildren(parent);
                boolean allChildrenTagged = children.stream().allMatch(result::contains);
                if (!allChildrenTagged) continue;
                anyMatch = true;
                result.removeAll(children);
                result.add(parent);
            }
        } while (anyMatch);
        return result;
    }

    public static <T> Tree<T> subTree(Tree<T> tree, T newRoot) {
        SubTree<T> result = new SubTree<T>(tree, newRoot);
        return result;
    }

    public static <T> long nodeCount(Tree<T> tree) {
        long result = Collections.singleton(tree.getRoot()).stream().flatMap(x -> tree.getChildren(x).stream()).count();
        return result;
    }

    public static <T> long depth(Tree<T> tree) {
        T root = tree.getRoot();
        long result = TreeUtils.depth(tree, root);
        return result;
    }

    public static <T> long depth(Tree<T> tree, T node) {
        long result;
        if (node == null) {
            result = 0L;
        } else {
            Collection<T> children = tree.getChildren(node);
            result = 1L + children.stream().mapToLong(child -> TreeUtils.depth(tree, child)).max().orElse(0L);
        }
        return result;
    }

    public static <T> int childIndexOf(TreeOps2<T> ops, T node) {
        List<T> children = ops.getParentToChildren().apply(node);
        int result = children.indexOf(node);
        return result;
    }

    public static <T> Tree<T> replace(Tree<T> tree, T node, T replacement) {
        Object newRoot = TreeUtils.replaceNode(tree, node, replacement, (a, b) -> a == b);
        Tree<Object> result = tree.createNew(newRoot);
        return result;
    }

    public static <T> int indexOf(List<T> list, T find, BiPredicate<? super T, ? super T> isEquiv) {
        T item;
        Iterator<T> it = list.iterator();
        int i = 0;
        boolean found = false;
        while (it.hasNext() && !(found = isEquiv.test(item = it.next(), find))) {
        }
        int result = found ? i : -1;
        return result;
    }

    public static <T> T replaceNode(Tree<T> tree, T node, T replacement, BiPredicate<? super T, ? super T> isEquiv) {
        T result;
        if (node == null) {
            result = replacement;
        } else {
            T parent = tree.getParent(node);
            ArrayList<T> children = new ArrayList<T>(tree.getChildren(parent));
            int i = TreeUtils.indexOf(children, node, isEquiv);
            children.set(i, replacement);
            T parentReplacement = tree.copy(parent, children);
            result = TreeUtils.replaceNode(tree, parent, parentReplacement, isEquiv);
        }
        return result;
    }

    public static <T> T substitute(T node, boolean descendIntoSubst, TreeOps2<T> ops, Function<? super T, ? extends T> transformFn) {
        T result = TreeUtils.substitute(node, descendIntoSubst, ops.getParentToChildren(), transformFn, ops.getReplaceChildren());
        return result;
    }

    public static <T> T substitute(T node, boolean descendIntoSubst, Function<? super T, ? extends Collection<? extends T>> getChildrenFn, Function<? super T, ? extends T> transformFn, BiFunction<T, List<T>, T> copyFn) {
        T result;
        T tmp = transformFn.apply(node);
        boolean descend = tmp == null || descendIntoSubst;
        T t = tmp = tmp == null ? node : tmp;
        if (descend) {
            List newSubOps = getChildrenFn.apply(tmp).stream().map(subOp -> TreeUtils.substitute(subOp, descendIntoSubst, getChildrenFn, transformFn, copyFn)).collect(Collectors.toList());
            result = copyFn.apply(node, newSubOps);
        } else {
            result = tmp;
        }
        return result;
    }

    public static <T> T findAncestor(Tree<T> tree, T node, Predicate<T> predicate) {
        T current = node;
        while ((current = tree.getParent(current)) != null && !predicate.test(current)) {
        }
        return current;
    }

    public static <T> Stream<T> inOrderSearch(T node, Function<T, ? extends Iterable<T>> parentToChildren) {
        Stream<T> result = Stream.of(node);
        Iterable<T> children = parentToChildren.apply(node);
        Stream<Object> childStream = StreamSupport.stream(children.spliterator(), false);
        result = Stream.concat(result, childStream.flatMap(c -> TreeUtils.inOrderSearch(c, parentToChildren)));
        return result;
    }

    public static <T, V> Stream<Map.Entry<T, V>> inOrderSearch(T node, Function<T, ? extends Iterable<T>> parentToChildren, Function<? super T, V> nodeToValue, BiPredicate<T, V> doDescend) {
        V value = nodeToValue.apply(node);
        AbstractMap.SimpleEntry<T, V> e = new AbstractMap.SimpleEntry<T, V>(node, value);
        boolean descend = doDescend.test(node, value);
        Stream<Map.Entry<T, V>> result = Stream.of(e);
        if (descend) {
            Iterable<T> children = parentToChildren.apply(node);
            Stream<Object> childStream = StreamSupport.stream(children.spliterator(), false);
            result = Stream.concat(result, childStream.flatMap(c -> TreeUtils.inOrderSearch(c, parentToChildren, nodeToValue, doDescend)));
        }
        return result;
    }

    public static <T> List<List<T>> innerNodesPerLevel(Tree<T> tree) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        T root = tree.getRoot();
        List<T> current = Collections.singletonList(root);
        while (!current.isEmpty()) {
            ArrayList<T> next = new ArrayList<T>();
            for (T node : current) {
                Collection<T> children = tree.getChildren(node);
                if (children.isEmpty() && node != root) continue;
                next.add(node);
            }
            if (!next.isEmpty()) {
                result.add(next);
            }
            current = next;
        }
        return result;
    }

    public static <T> List<List<T>> nodesPerLevel(Tree<T> tree) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        List<T> current = Collections.singletonList(tree.getRoot());
        while (!current.isEmpty()) {
            result.add(current);
            ArrayList<T> next = new ArrayList<T>();
            for (T node : current) {
                Collection<T> children = tree.getChildren(node);
                next.addAll(children);
            }
            current = next;
        }
        return result;
    }

    public static <T> Stream<T> leafStream(Tree<T> tree) {
        T root = tree.getRoot();
        Stream<Object> result = TreeUtils.inOrderSearch(root, tree::getChildren).filter(node -> node == null ? true : tree.getChildren(node).isEmpty());
        return result;
    }

    public static <T> List<T> getLeafs(Tree<T> tree) {
        List result = TreeUtils.leafStream(tree).collect(Collectors.toList());
        return result;
    }

    public static <T> void getLeafs(Collection<T> result, Tree<T> tree, T node) {
        Collection<T> children = tree.getChildren(node);
        if (children.isEmpty()) {
            result.add(node);
        } else {
            for (T child : children) {
                TreeUtils.getLeafs(result, tree, child);
            }
        }
    }

    public static <T> Set<T> getParentsOf(Tree<T> tree, Iterable<T> children) {
        HashSet<T> result = new HashSet<T>();
        for (T child : children) {
            T parent = tree.getParent(child);
            result.add(parent);
        }
        return result;
    }

    public static <T> Map<T, T> parentMap(T root, Function<T, List<T>> parentToChildren) {
        IdentityHashMap<T, Object> result = new IdentityHashMap<T, Object>();
        result.put(root, null);
        TreeUtils.parentMap(result, root, parentToChildren);
        return result;
    }

    public static <T> void parentMap(Map<T, T> result, T parent, Function<T, List<T>> parentToChildren) {
        List<T> children = parentToChildren.apply(parent);
        for (T child : children) {
            result.put(child, parent);
            TreeUtils.parentMap(result, child, parentToChildren);
        }
    }

    public static <T> Tree<T> remapSubTreesToLeafs(Tree<T> tree, Function<? super T, ? extends T> remapFn) {
        Map fwd = TreeUtils.inOrderSearch(tree.getRoot(), tree::getChildren, remapFn, (opNode, value) -> value == null).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, IdentityHashMap::new));
        IdentityHashMap bwd = new IdentityHashMap();
        for (Map.Entry e2 : fwd.entrySet()) {
            bwd.put(e2.getValue(), e2.getKey());
        }
        TreeReplace<T> result = new TreeReplace<T>(tree, fwd, bwd);
        return result;
    }

    public static <T> Tree<T> removeUnaryNodes(Tree<T> tree) {
        ListMultimap parentToChildren = MultimapUtils.newIdentityListMultimap();
        T newRoot = TreeUtils.removeUnaryNodes(tree, tree.getRoot(), parentToChildren);
        TreeImpl<Object> result = newRoot == null ? null : TreeImpl.create(newRoot, node -> parentToChildren.get(node));
        return result;
    }

    public static <T> T removeUnaryNodes(Tree<T> tree, T node, ListMultimap<T, T> parentToChildren) {
        T result;
        Collection<T> children = tree.getChildren(node);
        int childCount = children.size();
        switch (childCount) {
            case 0: {
                result = node;
                break;
            }
            case 1: {
                T child = children.iterator().next();
                result = TreeUtils.removeUnaryNodes(tree, child, parentToChildren);
                break;
            }
            default: {
                result = node;
                for (T c : children) {
                    T newChild = TreeUtils.removeUnaryNodes(tree, c, parentToChildren);
                    parentToChildren.put(node, newChild);
                }
            }
        }
        return result;
    }

    public static <T> Map<T, Multimap<T, T>> clusterNodesByFirstMultiaryAncestor(Tree<T> tree, Multimap<T, T> mapping) {
        HashMap<Object, Multimap> result = new HashMap<Object, Multimap>();
        Set entries = mapping.asMap().entrySet();
        for (Map.Entry entry : entries) {
            Object node = entry.getKey();
            T multiaryAncestor = tree.getParent(node);
            Collection queryNodes = (Collection)entry.getValue();
            for (Object targetNode : queryNodes) {
                Multimap mm = result.computeIfAbsent(multiaryAncestor, k -> HashMultimap.create());
                mm.put(node, targetNode);
            }
        }
        return result;
    }

    public static <T> T getFirstMultiaryAncestor(Tree<T> tree, T node) {
        T result = node;
        while ((result = tree.getParent(result)) != null && tree.getChildren(result).size() == 1) {
        }
        return result;
    }

    public static <T> T firstMultiaryAncestor(Tree<T> tree, T node) {
        Object result = null;
        T current = node;
        while (current != null) {
            Object parent = tree.getParent(result);
            Collection<Object> children = tree.getChildren(parent);
            int arity = children.size();
            if (arity > 1) {
                result = parent;
                break;
            }
            current = parent;
        }
        return result;
    }

    public static <X> List<X> getUnaryAncestors(X x, Tree<X> tree, Tree<X> multiaryTree) {
        ArrayList<X> result = new ArrayList<X>();
        X ancestor = multiaryTree.getParent(x);
        X currentNode = x;
        while ((currentNode = tree.getParent(currentNode)) != null && !currentNode.equals(ancestor)) {
            result.add(currentNode);
        }
        return result;
    }

    public static <A, B> Multimap<A, B> deriveParentMapping(Tree<A> aTree, Tree<B> bTree, Multimap<A, B> childMapping) {
        HashMultimap result = HashMultimap.create();
        Set as = childMapping.keySet();
        for (Object a : as) {
            A aParent = aTree.getParent(a);
            Collection bs = childMapping.get(a);
            Set<B> bParents = TreeUtils.getParentsOf(bTree, bs);
            result.putAll(aParent, bParents);
        }
        return result;
    }
}

