/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeBase;

public class SubTree<T>
extends TreeBase<T> {
    protected T root;
    protected Tree<T> delegate;
    protected BiPredicate<T, T> nodeComparator;

    public SubTree(Tree<T> delegate, T root) {
        this(delegate, root, (a, b) -> a == b);
    }

    public SubTree(Tree<T> delegate, T root, BiPredicate<T, T> nodeComparator) {
        this.root = root;
        this.delegate = delegate;
        this.nodeComparator = nodeComparator;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public Collection<T> getChildren(T node) {
        Collection<T> result = this.delegate.getChildren(node);
        return result;
    }

    @Override
    public T getParent(T node) {
        boolean isRoot = this.nodeComparator.test(node, this.root);
        T result = isRoot ? null : (T)this.delegate.getParent(node);
        return result;
    }

    @Override
    public T copy(T node, List<T> children) {
        T result = this.delegate.copy(node, children);
        return result;
    }

    @Override
    public Tree<T> createNew(T root) {
        Tree<T> result = this.delegate.createNew(root);
        return result;
    }
}

