/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public class ReclaimingSupplier<T>
implements Supplier<T> {
    protected Supplier<T> generator;
    protected Set<T> reclaims = new TreeSet<T>();

    public ReclaimingSupplier(Supplier<T> generator) {
        this.generator = generator;
    }

    public void reclaim(T item) {
        this.reclaims.add(item);
    }

    @Override
    public T get() {
        T result;
        Iterator<T> it = this.reclaims.iterator();
        if (it.hasNext()) {
            result = it.next();
            it.remove();
        } else {
            result = this.generator.get();
        }
        return result;
    }
}

