/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.commons.collections.reversible.ReversibleMap;
import org.aksw.commons.collections.reversible.ReversibleMapImpl;
import org.aksw.commons.collections.trees.LabeledNode;
import org.aksw.commons.collections.trees.ReclaimingSupplier;
import org.aksw.commons.collections.trees.Tree;

public class LabeledTree<K, X extends LabeledNode<K>>
implements Tree<K> {
    protected X rootNode;
    protected Map<K, X> keyToNode;
    protected K root;
    protected ReversibleMap<K, K> childToParent;
    protected ReclaimingSupplier<K> idSupplier;

    public LabeledTree() {
        this(null, new ReversibleMapImpl());
    }

    public LabeledTree(K root, ReversibleMap<K, K> childToParent) {
        this.root = root;
        this.childToParent = childToParent;
        this.keyToNode = new HashMap<K, X>();
    }

    @Override
    public K getRoot() {
        return this.root;
    }

    public X getNode(K key) {
        LabeledNode result = (LabeledNode)this.keyToNode.get(key);
        return (X)result;
    }

    @Override
    public Collection<K> getChildren(K node) {
        return this.childToParent.reverse().get(node);
    }

    @Override
    public K getParent(K node) {
        return (K)this.childToParent.get(node);
    }

    public X deleteNode(K node) {
        LabeledNode result = (LabeledNode)this.keyToNode.get(node);
        if (result != null) {
            result.destroy();
        }
        this.keyToNode.remove(node);
        this.childToParent.remove(node);
        return (X)result;
    }

    @Override
    public K copy(K node, List<K> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tree<K> createNew(K root) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long nodeCount() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "LabeledTree [root=" + this.root + "]" + this.childToParent.reverse().toString();
    }
}

