/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.trees;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.reversible.ReversibleMap;
import org.aksw.commons.collections.trees.LabeledNode;
import org.aksw.commons.collections.trees.LabeledTree;

public class LabeledNodeImpl<K, X extends LabeledNode<K>, Y extends LabeledTree<K, X>>
implements LabeledNode<K> {
    protected Y tree;
    protected K id;

    public LabeledNodeImpl(Y tree, K id) {
        this.tree = tree;
        this.id = id;
    }

    @Override
    public LabeledNode<K> getParent() {
        K parentKey = ((LabeledTree)this.tree).getParent(this.id);
        Object result = ((LabeledTree)this.tree).getNode(parentKey);
        return result;
    }

    public void appendChild(LabeledNode<K> child) {
        ((LabeledTree)this.tree).childToParent.put(child.getKey(), this.id);
    }

    @Override
    public Collection<X> getChildren() {
        ReversibleMap hierarchy = ((LabeledTree)this.tree).childToParent;
        final Set childKeys = hierarchy.reverse().get(this.id);
        return new AbstractCollection<X>(){

            @Override
            public Iterator<X> iterator() {
                final Iterator base = new ArrayList(childKeys).iterator();
                return new Iterator<X>(){

                    @Override
                    public boolean hasNext() {
                        return base.hasNext();
                    }

                    @Override
                    public X next() {
                        return ((LabeledTree)LabeledNodeImpl.this.tree).getNode(base.next());
                    }
                };
            }

            @Override
            public int size() {
                return childKeys.size();
            }
        };
    }

    @Override
    public LabeledTree<K, X> getTree() {
        return this.tree;
    }

    @Override
    public K getKey() {
        return this.id;
    }

    public String toString() {
        return "Node[" + this.id + (!((LabeledTree)this.tree).keyToNode.containsKey(this.id) ? " detached" : "") + "], parent: " + ((LabeledTree)this.tree).childToParent.get(this.id) + " children: " + ((LabeledTree)this.tree).childToParent.reverse().get(this.id);
    }

    @Override
    public void destroy() {
    }
}

