/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.tracker;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.diff.SetDiff;

public class TrackingSet<T>
extends AbstractSet<T> {
    protected SetDiff<T> diff;
    protected Set<T> delegate;

    public TrackingSet(Set<T> delegate) {
        this.delegate = delegate;
        this.diff = new SetDiff(new HashSet(), new HashSet(), null);
    }

    public SetDiff<T> getDiff() {
        return this.diff;
    }

    public void restore() {
        this.delegate.removeAll((Collection)this.diff.getAdded());
        this.delegate.addAll((Collection)this.diff.getRemoved());
    }

    @Override
    public boolean add(T e) {
        boolean result = this.delegate.add(e);
        if (result) {
            if (((Set)this.diff.getRemoved()).contains(e)) {
                ((Set)this.diff.getRemoved()).remove(e);
            } else {
                ((Set)this.diff.getAdded()).add(e);
            }
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.delegate.remove(o);
        if (result) {
            if (((Set)this.diff.getAdded()).contains(o)) {
                ((Set)this.diff.getAdded()).remove(o);
            } else {
                ((Set)this.diff.getRemoved()).add(o);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }
}

