/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.stacks;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.stacks.NestedStackIterator;

public class GenericNestedStack<T, P extends GenericNestedStack<T, P>>
extends AbstractCollection<T> {
    protected P parent;
    protected T value;
    protected int size;

    public GenericNestedStack(P parent, T value) {
        this.parent = parent;
        this.value = value;
        this.size = parent == null ? 1 : ((GenericNestedStack)parent).size + 1;
    }

    public P getParent() {
        return this.parent;
    }

    public T getValue() {
        return this.value;
    }

    public List<T> asList() {
        ArrayList result = new ArrayList(this);
        Collections.reverse(result);
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        NestedStackIterator result = new NestedStackIterator(this);
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }
}

