/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.cache;

import java.util.Iterator;
import org.aksw.commons.collections.cache.Cache;

public class CachingIterator<T>
implements Iterator<T> {
    protected Cache<T> cache;
    protected Iterator<T> delegate;
    protected int offset;

    public CachingIterator(Cache<T> cache, Iterator<T> delegate) {
        this(cache, delegate, 0);
    }

    public CachingIterator(Cache<T> cache, Iterator<T> delegate, int offset) {
        this.cache = cache;
        this.delegate = delegate;
        this.offset = offset;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        int cacheSize = this.cache.getCurrentSize();
        if (this.offset < cacheSize) {
            result = true;
        } else if (this.cache.isComplete() || this.cache.isAbandoned()) {
            result = false;
        } else {
            result = this.delegate.hasNext();
            if (!result) {
                this.cache.setComplete();
            }
        }
        return result;
    }

    @Override
    public T next() {
        Object result;
        if (this.offset < this.cache.getCurrentSize()) {
            result = this.cache.get(this.offset);
        } else {
            result = this.delegate.next();
            this.cache.add(result);
        }
        ++this.offset;
        return result;
    }
}

