/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SinglePrefetchIterator<T>
implements Iterator<T> {
    private static Logger logger = LoggerFactory.getLogger(SinglePrefetchIterator.class);
    private T current = null;
    private boolean finished = false;
    private boolean advance = true;

    protected abstract T prefetch() throws Exception;

    protected SinglePrefetchIterator() {
    }

    protected T finish() {
        this.finished = true;
        this.close();
        return null;
    }

    private void _prefetch() {
        try {
            this.current = this.prefetch();
        }
        catch (Exception e) {
            this.current = null;
            logger.error("Error prefetching data", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.advance) {
            this._prefetch();
            this.advance = false;
        }
        return !this.finished;
    }

    @Override
    public T next() {
        if (this.finished) {
            throw new IndexOutOfBoundsException();
        }
        if (this.advance) {
            this._prefetch();
        }
        this.advance = true;
        return this.current;
    }

    public void close() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

