/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.CollectionUtils;
import org.aksw.commons.collections.FlatMapView;

public class MultiMaps {
    public static <K, V> void putAll(Map<K, Set<V>> target, Map<? extends K, ? extends Set<? extends V>> source) {
        for (Map.Entry<K, Set<V>> entry : source.entrySet()) {
            MultiMaps.putAll(target, entry.getKey(), (Collection)entry.getValue());
        }
    }

    public static <K, V> void putAll(Map<K, Set<V>> map, K key, Collection<? extends V> vs) {
        Set<V> values = MultiMaps.addKey(map, key);
        values.addAll(vs);
    }

    public static <K, V> void put(Map<K, Set<V>> map, K key, V value) {
        Set<V> values = MultiMaps.addKey(map, key);
        values.add(value);
    }

    public static <K, V> boolean containsEntry(Map<K, Set<V>> map, K key, V value) {
        Set<V> values = map.get(key);
        return values == null ? false : values.contains(value);
    }

    public static <K, V> Collection<V> values(Map<K, Set<V>> map) {
        return new FlatMapView<V>(map.values());
    }

    public static <K, V> Set<V> addKey(Map<K, Set<V>> map, K key) {
        Set<V> values = map.get(key);
        if (values == null) {
            values = new HashSet<V>();
            map.put(key, values);
        }
        return values;
    }

    public static <K, V> void addAllKeys(Map<K, Set<V>> map, Iterable<K> keys) {
        for (K key : keys) {
            MultiMaps.addKey(map, key);
        }
    }

    public static <K, V> Map<K, Set<V>> copy(Map<K, Set<V>> source) {
        HashMap result = new HashMap();
        MultiMaps.putAll(result, source);
        return result;
    }

    public static <K, V> Map<V, Set<K>> reverse(Map<K, Set<V>> source) {
        HashMap result = new HashMap();
        for (Map.Entry<K, Set<V>> entry : source.entrySet()) {
            for (V value : entry.getValue()) {
                MultiMaps.put(result, value, entry.getKey());
            }
        }
        return result;
    }

    public static <K, V> Set<V> safeGet(Map<K, ? extends Collection<V>> map, Object key) {
        Collection<V> values = map.get(key);
        return values == null ? Collections.emptySet() : CollectionUtils.asSet(values);
    }

    public static <K, V> Set<V> safeGetAll(Map<K, ? extends Collection<V>> map, Collection<?> keys) {
        HashSet<V> result = new HashSet<V>();
        for (Object key : keys) {
            result.addAll(MultiMaps.safeGet(map, key));
        }
        return result;
    }

    public static <K, V> Collection<V> safeGetC(Map<K, ? extends Collection<V>> map, Object key) {
        Collection<V> values = map.get(key);
        return values == null ? Collections.emptySet() : values;
    }

    public static <T> Set<T> transitiveGetAll(Map<T, ? extends Collection<T>> map, Iterable<?> keys) {
        HashSet<T> result = new HashSet<T>();
        for (Object key : keys) {
            Set<T> tmp = MultiMaps.transitiveGet(map, key);
            result.addAll(tmp);
        }
        return result;
    }

    public static <T> Set<T> transitiveGet(Map<T, ? extends Collection<T>> map, Object key) {
        HashSet tmp;
        HashSet result = new HashSet(MultiMaps.safeGetC(map, key));
        HashSet<Object> open = new HashSet(result);
        HashSet<Object> next = new HashSet();
        do {
            for (Object e : open) {
                for (Object b : MultiMaps.safeGetC(map, e)) {
                    if (result.contains(b)) continue;
                    next.add(b);
                }
            }
            open.clear();
            result.addAll(next);
            tmp = next;
            next = open;
        } while (!(open = tmp).isEmpty());
        return result;
    }

    public static <T> Map<T, Set<T>> transitiveClosure(Map<T, Set<T>> map) {
        return MultiMaps.transitiveClosure(map, false);
    }

    public static <T> Map<T, Set<T>> transitiveClosure(Map<T, Set<T>> map, boolean inPlace) {
        return MultiMaps.transitiveClosureInPlace(inPlace ? map : MultiMaps.copy(map));
    }

    public static <T> Map<T, Set<T>> transitiveClosureInPlace(Map<T, Set<T>> map) {
        Map<T, Set<T>> open = map;
        Map<T, Set<T>> next = new HashMap<T, Set<T>>();
        while (true) {
            for (Map.Entry<T, Set<T>> edge : open.entrySet()) {
                T nodeA = edge.getKey();
                for (T nodeB : edge.getValue()) {
                    for (T nodeC : MultiMaps.safeGet(map, nodeB)) {
                        if (MultiMaps.containsEntry(map, nodeA, nodeC)) continue;
                        MultiMaps.put(next, nodeA, nodeC);
                    }
                }
            }
            if (next.isEmpty()) {
                return map;
            }
            MultiMaps.putAll(map, next);
            if (open == map) {
                open = new HashMap<T, Set<T>>();
            } else {
                open.clear();
            }
            HashMap<T, Set<T>> tmp = next;
            next = open;
            open = tmp;
        }
    }

    public static <T> Set<T> getCommonParent(Map<T, ? extends Collection<T>> map, T a, T b) {
        HashSet stableA = new HashSet();
        HashSet stableB = new HashSet();
        Set<Object> frontierA = new HashSet<T>();
        Set<Object> frontierB = new HashSet<T>();
        frontierA.add(a);
        frontierB.add(b);
        while (!frontierA.isEmpty() || !frontierB.isEmpty()) {
            Sets.SetView allB;
            Sets.SetView allA = Sets.union(frontierA, stableA);
            Sets.SetView intersection = Sets.intersection((Set)allA, (Set)(allB = Sets.union(frontierB, stableB)));
            if (!intersection.isEmpty()) {
                return intersection;
            }
            Set nextFrontierA = MultiMaps.safeGetAll(map, frontierA);
            Set nextFrontierB = MultiMaps.safeGetAll(map, frontierB);
            stableA.addAll(frontierA);
            stableB.addAll(frontierB);
            nextFrontierA.removeAll(stableA);
            nextFrontierB.removeAll(stableB);
            frontierA = nextFrontierA;
            frontierB = nextFrontierB;
        }
        return Collections.emptySet();
    }
}

