/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.FeatureMap;
import org.aksw.commons.collections.SetUtils;

public class FeatureMapImpl<K, V>
extends AbstractCollection<Map.Entry<Set<K>, V>>
implements FeatureMap<K, V> {
    protected Map<K, Integer> tagToCount = new HashMap<K, Integer>();
    protected Multimap<K, Set<K>> tagToTagSets = HashMultimap.create();
    protected Multimap<Set<K>, V> tagSetToValues = HashMultimap.create();
    protected Multimap<V, Set<K>> valueToTagSets = HashMultimap.create();

    @Override
    public Set<Set<K>> keySet() {
        Set result = this.tagSetToValues.keySet();
        return result;
    }

    @Override
    public Collection<V> values() {
        Collection result = this.tagSetToValues.values();
        return result;
    }

    @Override
    public Set<Map.Entry<Set<K>, Collection<V>>> entrySet() {
        Set<Map.Entry<Set<K>, Collection<V>>> result = this.tagSetToValues.asMap().entrySet();
        return result;
    }

    @Override
    public void put(Set<K> tagSet, V value) {
        this.tagSetToValues.put(tagSet, value);
        tagSet.forEach((? super T tag) -> {
            this.tagToTagSets.put(tag, (Object)tagSet);
            this.tagToCount.merge(tag, 1, Integer::sum);
        });
        this.valueToTagSets.put(value, tagSet);
    }

    @Override
    public boolean remove(Object value) {
        Collection tagSets = this.valueToTagSets.get(value);
        tagSets.forEach((? super T tagSet) -> tagSet.forEach((? super T tag) -> this.tagToCount.merge(tag, 1, (a, b) -> a - b)));
        return true;
    }

    @Override
    public Collection<Map.Entry<Set<K>, V>> getIfSupersetOf(Set<K> prototype) {
        Stream<Object> baseStream;
        Object leastUsedTag = prototype.stream().map(k -> new AbstractMap.SimpleEntry<Object, Integer>(k, this.tagToCount.getOrDefault(k, 0))).min((a, b) -> (Integer)a.getValue() - (Integer)b.getValue()).map(Map.Entry::getKey).orElse(null);
        if (leastUsedTag != null) {
            Collection rawTagSets = this.tagToTagSets.get(leastUsedTag);
            baseStream = rawTagSets.stream().filter(tagSet -> tagSet.containsAll(prototype)).flatMap(tagSet -> {
                Collection v = this.tagSetToValues.get(tagSet);
                Stream<Map.Entry> r = v.stream().map(w -> new AbstractMap.SimpleEntry<Set, Object>((Set)tagSet, w));
                return r;
            });
        } else {
            baseStream = this.tagSetToValues.entries().stream();
        }
        Collection result = baseStream.collect(Collectors.toList());
        return result;
    }

    @Override
    public Collection<Map.Entry<Set<K>, V>> getIfSubsetOf(Set<K> prototype) {
        int indexCount = prototype.isEmpty() ? Integer.MAX_VALUE : prototype.stream().mapToInt(tag -> this.tagToCount.getOrDefault(tag, 0)).sum();
        int totalCount = this.valueToTagSets.size();
        boolean useScan = indexCount >= totalCount;
        Stream<Object> tagSetStream = useScan ? this.tagSetToValues.keySet().stream() : Stream.concat(Stream.of(Collections.emptySet()), prototype.stream().flatMap(tag -> this.tagToTagSets.get(tag).stream()).distinct());
        Collection result = tagSetStream.filter(tagSet -> prototype.containsAll((Collection<?>)tagSet)).flatMap(tagSet -> {
            Collection values = this.tagSetToValues.get(tagSet);
            Stream<Map.Entry> r = values.stream().map(w -> new AbstractMap.SimpleEntry<Set, Object>((Set)tagSet, w));
            return r;
        }).collect(Collectors.toSet());
        return result;
    }

    @Override
    public String toString() {
        return "FeatureMapImpl [tagToCount=" + this.tagToCount + ", tagToTagSets=" + this.tagToTagSets + ", tagSetToValues=" + this.tagSetToValues + ", valueToTagSets=" + this.valueToTagSets + "]";
    }

    @Override
    public Iterator<Map.Entry<Set<K>, V>> iterator() {
        Iterator<Map.Entry<Set<K>, V>> result = this.tagSetToValues.entries().iterator();
        return result;
    }

    @Override
    public int size() {
        int result = this.tagSetToValues.size();
        return result;
    }

    @Override
    public Collection<V> get(Set<K> prototype) {
        Collection result = this.tagSetToValues.get(prototype);
        return result;
    }

    @Override
    public boolean removeValue(Object v) {
        Set<Set<K>> tagSets = this.getTagSets(v);
        boolean result = this.remove(tagSets);
        return result;
    }

    @Override
    public Set<Set<K>> getTagSets(Object v) {
        Set<Set<K>> result = SetUtils.asSet(this.valueToTagSets.get(v));
        return result;
    }
}

