/*
 * Decompiled with CFR 0.152.
 */
package org.ajbrown.dropwizard.ssm.config;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterResult;
import com.amazonaws.services.simplesystemsmanagement.model.ParameterNotFoundException;
import com.google.common.base.Strings;
import io.dropwizard.configuration.UndefinedEnvironmentVariableException;
import org.apache.commons.text.StrLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsmLookup
extends StrLookup<Object> {
    private static final Logger log = LoggerFactory.getLogger(SsmLookup.class);
    private final AWSSimpleSystemsManagement ssm;
    private final boolean strict;
    private final String namespacePrefix;

    public SsmLookup(AWSSimpleSystemsManagement ssm, boolean strict) {
        this(ssm, strict, null);
    }

    public SsmLookup(AWSSimpleSystemsManagement ssm, boolean strict, String namespacePrefix) {
        this.ssm = ssm;
        this.strict = strict;
        this.namespacePrefix = namespacePrefix;
    }

    public String lookup(String key) {
        String paramName = Strings.isNullOrEmpty((String)this.namespacePrefix) ? key : String.format("%s%s", this.namespacePrefix, key);
        GetParameterRequest request = new GetParameterRequest().withName(paramName).withWithDecryption(Boolean.valueOf(true));
        log.trace("Looking up value in ssm key '{}'", (Object)paramName);
        try {
            GetParameterResult result = this.ssm.getParameter(request);
            return result.getParameter().getValue();
        }
        catch (ParameterNotFoundException pnfe) {
            log.debug("Parameter not found in SSM: {}", (Object)paramName);
        }
        catch (Exception e) {
            log.warn(String.format("Error looking up parameter '%s' in SSM", paramName), (Throwable)e);
        }
        if (this.strict) {
            throw new UndefinedEnvironmentVariableException(String.format("No parameter found in SSM with name '%s'.  Could not substitute expression '%s'", paramName, key));
        }
        return null;
    }
}

