/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.utils.solder.util.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.agorava.utils.solder.util.collections.Multiset;
import org.agorava.utils.solder.util.collections.Multisets;
import org.agorava.utils.solder.util.collections.Objects;
import org.agorava.utils.solder.util.collections.Preconditions;

abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;

    AbstractMultiset() {
    }

    @Override
    public abstract Set<Multiset.Entry<E>> entrySet();

    @Override
    public int size() {
        long sum = 0L;
        for (Multiset.Entry<E> entry : this.entrySet()) {
            sum += (long)entry.getCount();
        }
        return (int)Math.min(sum, Integer.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.elementSet().contains(element);
    }

    @Override
    public Iterator<E> iterator() {
        return new MultisetIterator();
    }

    @Override
    public int count(Object element) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            if (!Objects.equal(entry.getElement(), element)) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    public boolean add(E element) {
        this.add(element, 1);
        return true;
    }

    @Override
    public int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, 1) > 0;
    }

    @Override
    public int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setCount(E element, int count) {
        return Multisets.setCountImpl(this, element, count);
    }

    @Override
    public boolean setCount(E element, int oldCount, int newCount) {
        return Multisets.setCountImpl(this, element, oldCount, newCount);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        return this.elementSet().containsAll(elements);
    }

    @Override
    public boolean addAll(Collection<? extends E> elementsToAdd) {
        if (elementsToAdd.isEmpty()) {
            return false;
        }
        if (elementsToAdd instanceof Multiset) {
            Multiset that = (Multiset)elementsToAdd;
            for (Multiset.Entry entry : that.entrySet()) {
                this.add(entry.getElement(), entry.getCount());
            }
        } else {
            super.addAll(elementsToAdd);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> elementsToRemove) {
        Collection<?> collection = elementsToRemove instanceof Multiset ? ((Multiset)elementsToRemove).elementSet() : elementsToRemove;
        return this.elementSet().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> elementsToRetain) {
        Preconditions.checkNotNull(elementsToRetain);
        Iterator<Multiset.Entry<E>> entries = this.entrySet().iterator();
        boolean modified = false;
        while (entries.hasNext()) {
            Multiset.Entry<E> entry = entries.next();
            if (elementsToRetain.contains(entry.getElement())) continue;
            entries.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public Set<E> elementSet() {
        Set<E> result = this.elementSet;
        if (result == null) {
            this.elementSet = result = this.createElementSet();
        }
        return result;
    }

    Set<E> createElementSet() {
        return new ElementSet();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset that = (Multiset)object;
            if (this.size() != that.size()) {
                return false;
            }
            for (Multiset.Entry entry : that.entrySet()) {
                if (this.count(entry.getElement()) == entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    private class ElementSet
    extends AbstractSet<E> {
        private ElementSet() {
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator entryIterator = AbstractMultiset.this.entrySet().iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                @Override
                public E next() {
                    return ((Multiset.Entry)entryIterator.next()).getElement();
                }

                @Override
                public void remove() {
                    entryIterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractMultiset.this.entrySet().size();
        }
    }

    private class MultisetIterator
    implements Iterator<E> {
        private final Iterator<Multiset.Entry<E>> entryIterator;
        private Multiset.Entry<E> currentEntry;
        private int laterCount;
        private int totalCount;
        private boolean canRemove;

        MultisetIterator() {
            this.entryIterator = AbstractMultiset.this.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.laterCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.laterCount == 0) {
                this.currentEntry = this.entryIterator.next();
                this.totalCount = this.laterCount = this.currentEntry.getCount();
            }
            --this.laterCount;
            this.canRemove = true;
            return this.currentEntry.getElement();
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.canRemove, "no calls to next() since the last call to remove()");
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                AbstractMultiset.this.remove(this.currentEntry.getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }
}

