/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.utils.solder.util.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.agorava.utils.solder.util.collections.AbstractMultiset;
import org.agorava.utils.solder.util.collections.Collections2;
import org.agorava.utils.solder.util.collections.Iterators;
import org.agorava.utils.solder.util.collections.Maps;
import org.agorava.utils.solder.util.collections.Multimap;
import org.agorava.utils.solder.util.collections.Multiset;
import org.agorava.utils.solder.util.collections.Multisets;
import org.agorava.utils.solder.util.collections.Preconditions;
import org.agorava.utils.solder.util.collections.SetMultimap;
import org.agorava.utils.solder.util.collections.Sets;
import org.agorava.utils.solder.util.collections.WrappedCollection;
import org.agorava.utils.solder.util.collections.WrappedList;

abstract class AbstractMultimap<K, V>
implements Multimap<K, V>,
Serializable {
    transient Map<K, Collection<V>> map;
    transient int totalSize;
    private transient Set<K> keySet;
    private transient Multiset<K> multiset;
    private transient Collection<V> valuesCollection;
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Map<K, Collection<V>> asMap;
    private static final long serialVersionUID = 2447537837011683357L;

    protected AbstractMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument(map.isEmpty());
        this.map = map;
    }

    final void setMap(Map<K, Collection<V>> map) {
        this.map = map;
        this.totalSize = 0;
        for (Collection<Collection<V>> values : map.values()) {
            Preconditions.checkArgument(!values.isEmpty());
            this.totalSize += values.size();
        }
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(K key) {
        return this.createCollection();
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Collection<V> collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        Collection<V> collection = this.map.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean put(K key, V value) {
        Collection<V> collection = this.getOrCreateCollection(key);
        if (collection.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<V> getOrCreateCollection(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            this.map.put(key, collection);
        }
        return collection;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            return false;
        }
        boolean changed = collection.remove(value);
        if (changed) {
            --this.totalSize;
            if (collection.isEmpty()) {
                this.map.remove(key);
            }
        }
        return changed;
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        if (!values.iterator().hasNext()) {
            return false;
        }
        Collection<V> collection = this.getOrCreateCollection(key);
        int oldSize = collection.size();
        boolean changed = false;
        if (values instanceof Collection) {
            Collection c = (Collection)values;
            changed = collection.addAll(c);
        } else {
            for (V value : values) {
                changed |= collection.add(value);
            }
        }
        this.totalSize += collection.size() - oldSize;
        return changed;
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return this.removeAll(key);
        }
        Collection<V> collection = this.getOrCreateCollection(key);
        Collection<V> oldValues = this.createCollection();
        oldValues.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator.hasNext()) {
            if (!collection.add(iterator.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass(oldValues);
    }

    @Override
    public Collection<V> removeAll(Object key) {
        Collection<V> collection = this.map.remove(key);
        Collection<V> output = this.createCollection();
        if (collection != null) {
            output.addAll(collection);
            this.totalSize -= collection.size();
            collection.clear();
        }
        return this.unmodifiableCollectionSubclass(output);
    }

    private Collection<V> unmodifiableCollectionSubclass(Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(K key) {
        Collection<V> collection = this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        return this.wrapCollection(key, collection);
    }

    private Collection<V> wrapCollection(K key, Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return new WrappedSortedSet(key, (SortedSet)collection, null);
        }
        if (collection instanceof Set) {
            return new WrappedSet(key, (Set)collection);
        }
        if (collection instanceof List) {
            return this.wrapList(key, (List)collection, null);
        }
        return new WrappedCollection<K, V>(this, key, collection, null);
    }

    List<V> wrapList(K key, List<V> list, WrappedCollection<K, V> ancestor) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(key, list, ancestor) : new WrappedList<K, V>(this, key, list, ancestor);
    }

    Iterator<V> iteratorOrListIterator(Collection<V> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    @Override
    public Set<K> keySet() {
        Set<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    private Set<K> createKeySet() {
        return this.map instanceof SortedMap ? new SortedKeySet((SortedMap)this.map) : new KeySet(this.map);
    }

    @Override
    public Multiset<K> keys() {
        MultisetView result = this.multiset;
        return result == null ? (this.multiset = new MultisetView()) : result;
    }

    private int removeValuesForKey(Object key) {
        Collection<V> collection;
        try {
            collection = this.map.remove(key);
        }
        catch (NullPointerException e) {
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
        int count = 0;
        if (collection != null) {
            count = collection.size();
            collection.clear();
            this.totalSize -= count;
        }
        return count;
    }

    @Override
    public Collection<V> values() {
        Values result = this.valuesCollection;
        return result == null ? (this.valuesCollection = new Values()) : result;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        return this.entries == null ? (this.entries = this.createEntries()) : result;
    }

    private Collection<Map.Entry<K, V>> createEntries() {
        return this instanceof SetMultimap ? new EntrySet() : new Entries();
    }

    Iterator<Map.Entry<K, V>> createEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<Collection<V>>> result = this.asMap;
        return result == null ? (this.asMap = this.createAsMap()) : result;
    }

    private Map<K, Collection<V>> createAsMap() {
        return this.map instanceof SortedMap ? new SortedAsMap((SortedMap)this.map) : new AsMap(this.map);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.map.equals(that.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    private class SortedAsMap
    extends AsMap
    implements SortedMap<K, Collection<V>> {
        SortedSet<K> sortedKeySet;

        SortedAsMap(SortedMap<K, Collection<V>> submap) {
            super(submap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedMap<K, Collection<V>> headMap(K toKey) {
            return new SortedAsMap(this.sortedMap().headMap(toKey));
        }

        @Override
        public SortedMap<K, Collection<V>> subMap(K fromKey, K toKey) {
            return new SortedAsMap(this.sortedMap().subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, Collection<V>> tailMap(K fromKey) {
            return new SortedAsMap(this.sortedMap().tailMap(fromKey));
        }

        @Override
        public SortedSet<K> keySet() {
            SortedKeySet result = this.sortedKeySet;
            return result == null ? (this.sortedKeySet = new SortedKeySet(this.sortedMap())) : result;
        }
    }

    private class AsMap
    extends AbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;
        transient Set<Map.Entry<K, Collection<V>>> entrySet;

        AsMap(Map<K, Collection<V>> submap) {
            this.submap = submap;
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            AsMapEntries result = this.entrySet;
            return this.entrySet == null ? (this.entrySet = new AsMapEntries()) : result;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.submap.containsKey(key);
        }

        @Override
        public Collection<V> get(Object key) {
            Collection collection = this.submap.get(key);
            if (collection == null) {
                return null;
            }
            Object k = key;
            return AbstractMultimap.this.wrapCollection(k, collection);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMultimap.this.keySet();
        }

        @Override
        public Collection<V> remove(Object key) {
            Collection collection = this.submap.remove(key);
            if (collection == null) {
                return null;
            }
            Collection output = AbstractMultimap.this.createCollection();
            output.addAll(collection);
            AbstractMultimap.this.totalSize -= collection.size();
            collection.clear();
            return output;
        }

        @Override
        public boolean equals(Object object) {
            return this == object || this.submap.equals(object);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            Collection<V> collection;

            AsMapIterator() {
                this.delegateIterator = AsMap.this.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry entry = this.delegateIterator.next();
                Object key = entry.getKey();
                this.collection = entry.getValue();
                return Maps.immutableEntry(key, AbstractMultimap.this.wrapCollection(key, this.collection));
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMultimap.this.totalSize -= this.collection.size();
                this.collection.clear();
            }
        }

        class AsMapEntries
        extends AbstractSet<Map.Entry<K, Collection<V>>> {
            AsMapEntries() {
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator();
            }

            @Override
            public int size() {
                return AsMap.this.submap.size();
            }

            @Override
            public boolean contains(Object o) {
                return AsMap.this.submap.entrySet().contains(o);
            }

            @Override
            public boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AbstractMultimap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }
    }

    private class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean equals(Object object) {
            return Collections2.setEquals(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        K key;
        Collection<V> collection;
        Iterator<V> valueIterator;

        EntryIterator() {
            this.keyIterator = AbstractMultimap.this.map.entrySet().iterator();
            if (this.keyIterator.hasNext()) {
                this.findValueIteratorAndKey();
            } else {
                this.valueIterator = Iterators.emptyModifiableIterator();
            }
        }

        void findValueIteratorAndKey() {
            Map.Entry entry = this.keyIterator.next();
            this.key = entry.getKey();
            this.collection = entry.getValue();
            this.valueIterator = this.collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.valueIterator.hasNext()) {
                this.findValueIteratorAndKey();
            }
            return Maps.immutableEntry(this.key, this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (this.collection.isEmpty()) {
                this.keyIterator.remove();
            }
            --AbstractMultimap.this.totalSize;
        }
    }

    private class Entries
    extends AbstractCollection<Map.Entry<K, V>> {
        private Entries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.createEntryIterator();
        }

        @Override
        public int size() {
            return AbstractMultimap.this.totalSize;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return AbstractMultimap.this.containsEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return AbstractMultimap.this.remove(entry.getKey(), entry.getValue());
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private ValueIterator() {
            this.entryIterator = AbstractMultimap.this.createEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return this.entryIterator.next().getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return AbstractMultimap.this.totalSize;
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        @Override
        public boolean contains(Object value) {
            return AbstractMultimap.this.containsValue(value);
        }
    }

    private class MultisetKeyIterator
    implements Iterator<K> {
        final Iterator<Map.Entry<K, V>> entryIterator;

        private MultisetKeyIterator() {
            this.entryIterator = AbstractMultimap.this.entries().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            return this.entryIterator.next().getKey();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }

    private class MultisetEntry
    extends Multisets.AbstractEntry<K> {
        final Map.Entry<K, Collection<V>> entry;

        public MultisetEntry(Map.Entry<K, Collection<V>> entry) {
            this.entry = entry;
        }

        @Override
        public K getElement() {
            return this.entry.getKey();
        }

        @Override
        public int getCount() {
            return this.entry.getValue().size();
        }
    }

    private class MultisetEntryIterator
    implements Iterator<Multiset.Entry<K>> {
        final Iterator<Map.Entry<K, Collection<V>>> asMapIterator;

        private MultisetEntryIterator() {
            this.asMapIterator = AbstractMultimap.this.asMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.asMapIterator.hasNext();
        }

        @Override
        public Multiset.Entry<K> next() {
            return new MultisetEntry(this.asMapIterator.next());
        }

        @Override
        public void remove() {
            this.asMapIterator.remove();
        }
    }

    private class MultisetView
    extends AbstractMultiset<K> {
        transient Set<Multiset.Entry<K>> entrySet;

        private MultisetView() {
        }

        @Override
        public int remove(Object key, int occurrences) {
            Collection collection;
            if (occurrences == 0) {
                return this.count(key);
            }
            Preconditions.checkArgument(occurrences > 0);
            try {
                collection = AbstractMultimap.this.map.get(key);
            }
            catch (NullPointerException e) {
                return 0;
            }
            catch (ClassCastException e) {
                return 0;
            }
            if (collection == null) {
                return 0;
            }
            int count = collection.size();
            if (occurrences >= count) {
                return AbstractMultimap.this.removeValuesForKey(key);
            }
            Iterator iterator = collection.iterator();
            for (int i = 0; i < occurrences; ++i) {
                iterator.next();
                iterator.remove();
            }
            AbstractMultimap.this.totalSize -= occurrences;
            return count;
        }

        @Override
        public Set<K> elementSet() {
            return AbstractMultimap.this.keySet();
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            EntrySet result = this.entrySet;
            return result == null ? (this.entrySet = new EntrySet()) : result;
        }

        @Override
        public Iterator<K> iterator() {
            return new MultisetKeyIterator();
        }

        @Override
        public int count(Object key) {
            try {
                Collection collection = AbstractMultimap.this.map.get(key);
                return collection == null ? 0 : collection.size();
            }
            catch (NullPointerException e) {
                return 0;
            }
            catch (ClassCastException e) {
                return 0;
            }
        }

        @Override
        public int size() {
            return AbstractMultimap.this.totalSize;
        }

        @Override
        public void clear() {
            AbstractMultimap.this.clear();
        }

        private class EntrySet
        extends AbstractSet<Multiset.Entry<K>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Multiset.Entry<K>> iterator() {
                return new MultisetEntryIterator();
            }

            @Override
            public int size() {
                return AbstractMultimap.this.map.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Multiset.Entry)) {
                    return false;
                }
                Multiset.Entry entry = (Multiset.Entry)o;
                Collection collection = AbstractMultimap.this.map.get(entry.getElement());
                return collection != null && collection.size() == entry.getCount();
            }

            @Override
            public void clear() {
                AbstractMultimap.this.clear();
            }

            @Override
            public boolean remove(Object o) {
                return this.contains(o) && AbstractMultimap.this.removeValuesForKey(((Multiset.Entry)o).getElement()) > 0;
            }
        }
    }

    private class SortedKeySet
    extends KeySet
    implements SortedSet<K> {
        SortedKeySet(SortedMap<K, Collection<V>> subMap) {
            super(subMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.subMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K first() {
            return this.sortedMap().firstKey();
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return new SortedKeySet(this.sortedMap().headMap(toElement));
        }

        @Override
        public K last() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return new SortedKeySet(this.sortedMap().subMap(fromElement, toElement));
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return new SortedKeySet(this.sortedMap().tailMap(fromElement));
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        final Map<K, Collection<V>> subMap;

        KeySet(Map<K, Collection<V>> subMap) {
            this.subMap = subMap;
        }

        @Override
        public int size() {
            return this.subMap.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                final Iterator<Map.Entry<K, Collection<V>>> entryIterator;
                Map.Entry<K, Collection<V>> entry;
                {
                    this.entryIterator = KeySet.this.subMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = this.entryIterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.entry != null);
                    Collection collection = this.entry.getValue();
                    this.entryIterator.remove();
                    AbstractMultimap.this.totalSize -= collection.size();
                    collection.clear();
                }
            };
        }

        @Override
        public boolean contains(Object key) {
            return this.subMap.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            int count = 0;
            Collection collection = this.subMap.remove(key);
            if (collection != null) {
                count = collection.size();
                collection.clear();
                AbstractMultimap.this.totalSize -= count;
            }
            return count > 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.subMap.keySet().containsAll(c);
        }

        @Override
        public boolean equals(Object object) {
            return this == object || this.subMap.keySet().equals(object);
        }

        @Override
        public int hashCode() {
            return this.subMap.keySet().hashCode();
        }
    }

    private class RandomAccessWrappedList
    extends WrappedList<K, V>
    implements RandomAccess {
        RandomAccessWrappedList(K key, List<V> delegate, WrappedCollection<K, V> ancestor) {
            super(AbstractMultimap.this, key, delegate, ancestor);
        }
    }

    private class WrappedSortedSet
    extends WrappedCollection<K, V>
    implements SortedSet<V> {
        WrappedSortedSet(K key, SortedSet<V> delegate, WrappedCollection<K, V> ancestor) {
            super(AbstractMultimap.this, key, delegate, ancestor);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        @Override
        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        @Override
        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        @Override
        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        @Override
        public SortedSet<V> headSet(V toElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(toElement), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> subSet(V fromElement, V toElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(fromElement, toElement), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> tailSet(V fromElement) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(fromElement), this.getAncestor() == null ? this : this.getAncestor());
        }
    }

    private class WrappedSet
    extends WrappedCollection<K, V>
    implements Set<V> {
        WrappedSet(K key, Set<V> delegate) {
            super(AbstractMultimap.this, key, delegate, null);
        }
    }
}

