/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.utils.solder.support;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;

public class BeanManagerUtils {
    public static BeanManager getBeanManager() {
        BeanManagerProvider provider = BeanManagerProvider.getInstance();
        if (BeanManagerProvider.isActive()) {
            return provider.getBeanManager();
        }
        throw new RuntimeException("Unable to locate the BeanManager");
    }

    public static <T> T getContextualInstance(Class<T> type) {
        BeanManager beanManager = BeanManagerUtils.getBeanManager();
        return BeanManagerUtils.getContextualInstance(beanManager, type);
    }

    public static <T> T getContextualInstance(BeanManager beanManager, Class<T> type) {
        CreationalContext context;
        Object result = null;
        Bean bean = beanManager.resolve(beanManager.getBeans(type, new Annotation[0]));
        if (bean != null && (context = beanManager.createCreationalContext((Contextual)bean)) != null) {
            result = beanManager.getReference(bean, type, context);
        }
        return (T)result;
    }
}

