/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.utils.solder.reflection.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.agorava.utils.solder.reflection.annotated.AnnotatedTypeImpl;
import org.agorava.utils.solder.reflection.annotated.AnnotationBuilder;
import org.agorava.utils.solder.reflection.annotated.AnnotationRedefiner;
import org.agorava.utils.solder.reflection.annotated.AnnotationStore;
import org.agorava.utils.solder.reflection.annotated.Parameter;
import org.agorava.utils.solder.reflection.annotated.RedefinitionContext;
import org.agorava.utils.solder.support.SolderMessages;
import org.apache.deltaspike.core.api.exclude.annotation.Exclude;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.core.util.securitymanaged.SetAccessiblePrivilegedAction;

@Exclude
public class SolderAnnotatedTypeBuilder<X> {
    private SolderMessages messages;
    private Class<X> javaClass;
    private final AnnotationBuilder typeAnnotations = new AnnotationBuilder();
    private final Map<Constructor<?>, AnnotationBuilder> constructors = new HashMap();
    private final Map<Constructor<?>, Map<Integer, AnnotationBuilder>> constructorParameters = new HashMap();
    private final Map<Constructor<?>, Map<Integer, Type>> constructorParameterTypes = new HashMap();
    private final Map<Field, AnnotationBuilder> fields = new HashMap<Field, AnnotationBuilder>();
    private final Map<Field, Type> fieldTypes = new HashMap<Field, Type>();
    private final Map<Method, AnnotationBuilder> methods = new HashMap<Method, AnnotationBuilder>();
    private final Map<Method, Map<Integer, AnnotationBuilder>> methodParameters = new HashMap<Method, Map<Integer, AnnotationBuilder>>();
    private final Map<Method, Map<Integer, Type>> methodParameterTypes = new HashMap<Method, Map<Integer, Type>>();

    public SolderAnnotatedTypeBuilder() {
        this.messages = new SolderMessages();
    }

    public SolderAnnotatedTypeBuilder<X> addToClass(Annotation annotation) {
        this.typeAnnotations.add(annotation);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromClass(Class<? extends Annotation> annotationType) {
        this.typeAnnotations.remove(annotationType);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> addToField(Field field, Annotation annotation) {
        if (this.fields.get(field) == null) {
            this.fields.put(field, new AnnotationBuilder());
        }
        this.fields.get(field).add(annotation);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> addToField(AnnotatedField<? super X> field, Annotation annotation) {
        return this.addToField(field.getJavaMember(), annotation);
    }

    public SolderAnnotatedTypeBuilder<X> removeFromField(Field field, Class<? extends Annotation> annotationType) {
        if (this.fields.get(field) == null) {
            throw new IllegalArgumentException("field " + field + " not present on class " + this.getJavaClass());
        }
        this.fields.get(field).remove(annotationType);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromField(AnnotatedField<? super X> field, Class<? extends Annotation> annotationType) {
        return this.removeFromField(field.getJavaMember(), annotationType);
    }

    public SolderAnnotatedTypeBuilder<X> addToMethod(Method method, Annotation annotation) {
        if (this.methods.get(method) == null) {
            this.methods.put(method, new AnnotationBuilder());
        }
        this.methods.get(method).add(annotation);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> addToMethod(AnnotatedMethod<? super X> method, Annotation annotation) {
        return this.addToMethod(method.getJavaMember(), annotation);
    }

    public SolderAnnotatedTypeBuilder<X> removeFromMethod(Method method, Class<? extends Annotation> annotationType) {
        if (this.methods.get(method) == null) {
            throw new IllegalArgumentException("Method " + method + " not present on class" + this.getJavaClass());
        }
        this.methods.get(method).remove(annotationType);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromMethod(AnnotatedMethod<? super X> method, Class<? extends Annotation> annotationType) {
        return this.removeFromMethod(method.getJavaMember(), annotationType);
    }

    public SolderAnnotatedTypeBuilder<X> addToMethodParameter(Method method, int position, Annotation annotation) {
        if (!this.methods.containsKey(method)) {
            this.methods.put(method, new AnnotationBuilder());
        }
        if (this.methodParameters.get(method) == null) {
            this.methodParameters.put(method, new HashMap());
        }
        if (this.methodParameters.get(method).get(position) == null) {
            this.methodParameters.get(method).put(position, new AnnotationBuilder());
        }
        this.methodParameters.get(method).get(position).add(annotation);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromMethodParameter(Method method, int position, Class<? extends Annotation> annotationType) {
        if (this.methods.get(method) == null) {
            throw new IllegalArgumentException("Method " + method + " not present on class " + this.getJavaClass());
        }
        if (this.methodParameters.get(method).get(position) == null) {
            throw new IllegalArgumentException(String.format("parameter %s not present on method %s declared on class %s", method, position, this.getJavaClass()));
        }
        this.methodParameters.get(method).get(position).remove(annotationType);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> addToConstructor(Constructor<X> constructor, Annotation annotation) {
        if (this.constructors.get(constructor) == null) {
            this.constructors.put(constructor, new AnnotationBuilder());
        }
        this.constructors.get(constructor).add(annotation);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> addToConstructor(AnnotatedConstructor<X> constructor, Annotation annotation) {
        return this.addToConstructor(constructor.getJavaMember(), annotation);
    }

    public SolderAnnotatedTypeBuilder<X> removeFromConstructor(Constructor<X> constructor, Class<? extends Annotation> annotationType) {
        if (this.constructors.get(constructor) != null) {
            this.constructors.get(constructor).remove(annotationType);
        }
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromConstructor(AnnotatedConstructor<X> constructor, Class<? extends Annotation> annotationType) {
        return this.removeFromConstructor(constructor.getJavaMember(), annotationType);
    }

    public SolderAnnotatedTypeBuilder<X> addToConstructorParameter(Constructor<X> constructor, int position, Annotation annotation) {
        if (!this.constructors.containsKey(constructor)) {
            this.constructors.put(constructor, new AnnotationBuilder());
        }
        if (this.constructorParameters.get(constructor) == null) {
            this.constructorParameters.put(constructor, new HashMap());
        }
        if (this.constructorParameters.get(constructor).get(position) == null) {
            this.constructorParameters.get(constructor).put(position, new AnnotationBuilder());
        }
        this.constructorParameters.get(constructor).get(position).add(annotation);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromConstructorParameter(Constructor<X> constructor, int position, Class<? extends Annotation> annotationType) {
        if (this.constructorParameters.get(constructor) != null && this.constructorParameters.get(constructor).get(position) != null) {
            this.constructorParameters.get(constructor).get(position).remove(annotationType);
        }
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> removeFromParameter(AnnotatedParameter<? super X> parameter, Class<? extends Annotation> annotationType) {
        if (parameter.getDeclaringCallable().getJavaMember() instanceof Method) {
            Method method = (Method)parameter.getDeclaringCallable().getJavaMember();
            return this.removeFromMethodParameter(method, parameter.getPosition(), annotationType);
        }
        if (parameter.getDeclaringCallable().getJavaMember() instanceof Constructor) {
            Constructor constructor = (Constructor)parameter.getDeclaringCallable().getJavaMember();
            return this.removeFromConstructorParameter(constructor, parameter.getPosition(), annotationType);
        }
        throw new IllegalArgumentException("Cannot remove from parameter " + parameter + " - cannot operate on member " + parameter.getDeclaringCallable().getJavaMember());
    }

    public SolderAnnotatedTypeBuilder<X> addToParameter(AnnotatedParameter<? super X> parameter, Annotation annotation) {
        if (parameter.getDeclaringCallable().getJavaMember() instanceof Method) {
            Method method = (Method)parameter.getDeclaringCallable().getJavaMember();
            return this.addToMethodParameter(method, parameter.getPosition(), annotation);
        }
        if (parameter.getDeclaringCallable().getJavaMember() instanceof Constructor) {
            Constructor constructor = (Constructor)parameter.getDeclaringCallable().getJavaMember();
            return this.addToConstructorParameter(constructor, parameter.getPosition(), annotation);
        }
        throw new IllegalArgumentException("Cannot remove from parameter " + parameter + " - cannot operate on member " + parameter.getDeclaringCallable().getJavaMember());
    }

    public SolderAnnotatedTypeBuilder<X> removeFromAll(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "annotationType"));
        }
        this.removeFromClass(annotationType);
        for (Map.Entry<Field, AnnotationBuilder> entry : this.fields.entrySet()) {
            entry.getValue().remove(annotationType);
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.methods.entrySet()) {
            entry.getValue().remove(annotationType);
            if (this.methodParameters.get(entry.getKey()) == null) continue;
            for (Map.Entry<Integer, AnnotationBuilder> parameter : this.methodParameters.get(entry.getKey()).entrySet()) {
                parameter.getValue().remove(annotationType);
            }
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.constructors.entrySet()) {
            entry.getValue().remove(annotationType);
            if (this.constructorParameters.get(entry.getKey()) == null) continue;
            for (Map.Entry<Integer, AnnotationBuilder> parameter : this.constructorParameters.get(entry.getKey()).entrySet()) {
                parameter.getValue().remove(annotationType);
            }
        }
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> readFromType(AnnotatedType<X> type) {
        return this.readFromType(type, true);
    }

    public SolderAnnotatedTypeBuilder<X> readFromType(AnnotatedType<X> type, boolean overwrite) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "type"));
        }
        if (this.javaClass == null || overwrite) {
            this.javaClass = type.getJavaClass();
        }
        this.mergeAnnotationsOnElement((Annotated)type, overwrite, this.typeAnnotations);
        for (AnnotatedField field : type.getFields()) {
            if (this.fields.get(field.getJavaMember()) == null) {
                this.fields.put(field.getJavaMember(), new AnnotationBuilder());
            }
            this.mergeAnnotationsOnElement((Annotated)field, overwrite, this.fields.get(field.getJavaMember()));
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (this.methods.get(method.getJavaMember()) == null) {
                this.methods.put(method.getJavaMember(), new AnnotationBuilder());
            }
            this.mergeAnnotationsOnElement((Annotated)method, overwrite, this.methods.get(method.getJavaMember()));
            for (AnnotatedParameter p : method.getParameters()) {
                if (this.methodParameters.get(method.getJavaMember()) == null) {
                    this.methodParameters.put(method.getJavaMember(), new HashMap());
                }
                if (this.methodParameters.get(method.getJavaMember()).get(p.getPosition()) == null) {
                    this.methodParameters.get(method.getJavaMember()).put(p.getPosition(), new AnnotationBuilder());
                }
                this.mergeAnnotationsOnElement((Annotated)p, overwrite, this.methodParameters.get(method.getJavaMember()).get(p.getPosition()));
            }
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (this.constructors.get(constructor.getJavaMember()) == null) {
                this.constructors.put(constructor.getJavaMember(), new AnnotationBuilder());
            }
            this.mergeAnnotationsOnElement((Annotated)constructor, overwrite, this.constructors.get(constructor.getJavaMember()));
            for (AnnotatedParameter p : constructor.getParameters()) {
                if (this.constructorParameters.get(constructor.getJavaMember()) == null) {
                    this.constructorParameters.put(constructor.getJavaMember(), new HashMap());
                }
                if (this.constructorParameters.get(constructor.getJavaMember()).get(p.getPosition()) == null) {
                    this.constructorParameters.get(constructor.getJavaMember()).put(p.getPosition(), new AnnotationBuilder());
                }
                this.mergeAnnotationsOnElement((Annotated)p, overwrite, this.constructorParameters.get(constructor.getJavaMember()).get(p.getPosition()));
            }
        }
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> readFromType(Class<X> type) {
        return this.readFromType(type, true);
    }

    public SolderAnnotatedTypeBuilder<X> readFromType(Class<X> type, boolean overwrite) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "type"));
        }
        if (this.javaClass == null || overwrite) {
            this.javaClass = type;
        }
        for (Annotation annotation : type.getAnnotations()) {
            if (!overwrite && this.typeAnnotations.isAnnotationPresent(annotation.annotationType())) continue;
            this.typeAnnotations.add(annotation);
        }
        for (Field field : ReflectionUtils.getAllDeclaredFields(type)) {
            AnnotationBuilder annotationBuilder = this.fields.get(field);
            if (annotationBuilder == null) {
                annotationBuilder = new AnnotationBuilder();
                this.fields.put(field, annotationBuilder);
            }
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new SetAccessiblePrivilegedAction((AccessibleObject)field));
            } else {
                field.setAccessible(true);
            }
            for (Annotation annotation : field.getAnnotations()) {
                if (!overwrite && annotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                annotationBuilder.add(annotation);
            }
        }
        for (Method method : ReflectionUtils.getAllDeclaredMethods(type)) {
            AnnotationBuilder annotationBuilder = this.methods.get(method);
            if (annotationBuilder == null) {
                annotationBuilder = new AnnotationBuilder();
                this.methods.put(method, annotationBuilder);
            }
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new SetAccessiblePrivilegedAction((AccessibleObject)method));
            } else {
                method.setAccessible(true);
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!overwrite && annotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                annotationBuilder.add(annotation);
            }
            Map<Integer, AnnotationBuilder> parameters = this.methodParameters.get(method);
            if (parameters == null) {
                parameters = new HashMap<Integer, AnnotationBuilder>();
                this.methodParameters.put(method, parameters);
            }
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                AnnotationBuilder parameterAnnotationBuilder = parameters.get(i);
                if (parameterAnnotationBuilder == null) {
                    parameterAnnotationBuilder = new AnnotationBuilder();
                    parameters.put(i, parameterAnnotationBuilder);
                }
                for (Annotation annotation : method.getParameterAnnotations()[i]) {
                    if (!overwrite && parameterAnnotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                    parameterAnnotationBuilder.add(annotation);
                }
            }
        }
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            AnnotationBuilder annotationBuilder = this.constructors.get(constructor);
            if (annotationBuilder == null) {
                annotationBuilder = new AnnotationBuilder();
                this.constructors.put(constructor, annotationBuilder);
            }
            constructor.setAccessible(true);
            for (Annotation annotation : constructor.getAnnotations()) {
                if (!overwrite && annotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                annotationBuilder.add(annotation);
            }
            Map<Integer, AnnotationBuilder> mparams = this.constructorParameters.get(constructor);
            if (mparams == null) {
                mparams = new HashMap<Integer, AnnotationBuilder>();
                this.constructorParameters.put(constructor, mparams);
            }
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                AnnotationBuilder parameterAnnotationBuilder = mparams.get(i);
                if (parameterAnnotationBuilder == null) {
                    parameterAnnotationBuilder = new AnnotationBuilder();
                    mparams.put(i, parameterAnnotationBuilder);
                }
                for (Annotation annotation : constructor.getParameterAnnotations()[i]) {
                    if (!overwrite && parameterAnnotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                    annotationBuilder.add(annotation);
                }
            }
        }
        return this;
    }

    protected void mergeAnnotationsOnElement(Annotated annotated, boolean overwriteExisting, AnnotationBuilder typeAnnotations) {
        for (Annotation annotation : annotated.getAnnotations()) {
            if (typeAnnotations.getAnnotation(annotation.annotationType()) != null) {
                if (!overwriteExisting) continue;
                typeAnnotations.remove(annotation.annotationType());
                typeAnnotations.add(annotation);
                continue;
            }
            typeAnnotations.add(annotation);
        }
    }

    public AnnotatedType<X> create() {
        HashMap parameterAnnotations;
        HashMap constructorParameterAnnotations = new HashMap();
        HashMap constructorAnnotations = new HashMap();
        HashMap<Method, Map<Integer, AnnotationStore>> methodParameterAnnotations = new HashMap<Method, Map<Integer, AnnotationStore>>();
        HashMap<Method, AnnotationStore> methodAnnotations = new HashMap<Method, AnnotationStore>();
        HashMap<Field, AnnotationStore> fieldAnnotations = new HashMap<Field, AnnotationStore>();
        for (Map.Entry<Field, AnnotationBuilder> entry : this.fields.entrySet()) {
            fieldAnnotations.put(entry.getKey(), entry.getValue().create());
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.methods.entrySet()) {
            methodAnnotations.put((Method)entry.getKey(), entry.getValue().create());
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.methodParameters.entrySet()) {
            parameterAnnotations = new HashMap();
            methodParameterAnnotations.put((Method)entry.getKey(), parameterAnnotations);
            for (Map.Entry parameter : ((Map)entry.getValue()).entrySet()) {
                parameterAnnotations.put(parameter.getKey(), ((AnnotationBuilder)parameter.getValue()).create());
            }
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.constructors.entrySet()) {
            constructorAnnotations.put((Constructor<?>)entry.getKey(), ((AnnotationBuilder)entry.getValue()).create());
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.constructorParameters.entrySet()) {
            parameterAnnotations = new HashMap();
            constructorParameterAnnotations.put((Constructor<?>)entry.getKey(), (Map<Integer, AnnotationStore>)parameterAnnotations);
            for (Map.Entry parameter : ((Map)entry.getValue()).entrySet()) {
                parameterAnnotations.put(parameter.getKey(), ((AnnotationBuilder)parameter.getValue()).create());
            }
        }
        return new AnnotatedTypeImpl<X>(this.javaClass, this.typeAnnotations.create(), fieldAnnotations, methodAnnotations, methodParameterAnnotations, constructorAnnotations, constructorParameterAnnotations, this.fieldTypes, this.methodParameterTypes, this.constructorParameterTypes);
    }

    public void overrideFieldType(Field field, Type type) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "field"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "type"));
        }
        this.fieldTypes.put(field, type);
    }

    public void overrideFieldType(AnnotatedField<? super X> field, Type type) {
        this.overrideFieldType(field.getJavaMember(), type);
    }

    public SolderAnnotatedTypeBuilder<X> overrideMethodParameterType(Method method, int position, Type type) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "method"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "type"));
        }
        if (this.methodParameterTypes.get(method) == null) {
            this.methodParameterTypes.put(method, new HashMap());
        }
        this.methodParameterTypes.get(method).put(position, type);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> overrideConstructorParameterType(Constructor<X> constructor, int position, Type type) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "constructor"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("%s parameter must not be null", "type"));
        }
        if (this.constructorParameterTypes.get(constructor) == null) {
            this.constructorParameterTypes.put(constructor, new HashMap());
        }
        this.constructorParameterTypes.get(constructor).put(position, type);
        return this;
    }

    public SolderAnnotatedTypeBuilder<X> overrideParameterType(AnnotatedParameter<? super X> parameter, Type type) {
        if (parameter.getDeclaringCallable().getJavaMember() instanceof Method) {
            Method method = (Method)parameter.getDeclaringCallable().getJavaMember();
            return this.overrideMethodParameterType(method, parameter.getPosition(), type);
        }
        if (parameter.getDeclaringCallable().getJavaMember() instanceof Constructor) {
            Constructor constructor = (Constructor)parameter.getDeclaringCallable().getJavaMember();
            return this.overrideConstructorParameterType(constructor, parameter.getPosition(), type);
        }
        throw new IllegalArgumentException("Cannot remove from parameter " + parameter + " - cannot operate on member " + parameter.getDeclaringCallable().getJavaMember());
    }

    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    public SolderAnnotatedTypeBuilder<X> setJavaClass(Class<X> javaClass) {
        this.javaClass = javaClass;
        return this;
    }

    public <A extends Annotation> SolderAnnotatedTypeBuilder<X> redefine(Class<A> annotationType, AnnotationRedefiner<A> redefinition) {
        Parameter p;
        if (annotationType == null) {
            throw new IllegalArgumentException(this.messages.parameterMustNotBeNull("annotationType"));
        }
        if (redefinition == null) {
            throw new IllegalArgumentException(this.messages.parameterMustNotBeNull("redefinition"));
        }
        this.redefineAnnotationBuilder(annotationType, redefinition, this.javaClass, this.javaClass, this.typeAnnotations, null);
        for (Map.Entry<Field, AnnotationBuilder> entry : this.fields.entrySet()) {
            this.redefineAnnotationBuilder(annotationType, redefinition, entry.getKey(), entry.getKey().getGenericType(), entry.getValue(), entry.getKey().getName());
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.methods.entrySet()) {
            this.redefineAnnotationBuilder(annotationType, redefinition, entry.getKey(), ((Method)entry.getKey()).getGenericReturnType(), entry.getValue(), ((Method)entry.getKey()).getName());
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.constructors.entrySet()) {
            this.redefineAnnotationBuilder(annotationType, redefinition, entry.getKey(), ((Constructor)entry.getKey()).getDeclaringClass(), entry.getValue(), null);
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.methods.entrySet()) {
            if (this.methodParameters.get(entry.getKey()) == null) continue;
            for (Map.Entry<Integer, AnnotationBuilder> parameter : this.methodParameters.get(entry.getKey()).entrySet()) {
                p = Parameter.create((Member)((Object)entry.getKey()), parameter.getKey());
                this.redefineAnnotationBuilder(annotationType, redefinition, p, p.getBaseType(), parameter.getValue(), null);
            }
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.constructors.entrySet()) {
            if (this.constructorParameters.get(entry.getKey()) == null) continue;
            for (Map.Entry<Integer, AnnotationBuilder> parameter : this.constructorParameters.get(entry.getKey()).entrySet()) {
                p = Parameter.create((Member)((Object)entry.getKey()), parameter.getKey());
                this.redefineAnnotationBuilder(annotationType, redefinition, p, p.getBaseType(), parameter.getValue(), null);
            }
        }
        return this;
    }

    protected <A extends Annotation> void redefineAnnotationBuilder(Class<A> annotationType, AnnotationRedefiner<A> redefinition, AnnotatedElement annotated, Type baseType, AnnotationBuilder builder, String elementName) {
        if (builder.isAnnotationPresent(annotationType)) {
            redefinition.redefine(new RedefinitionContext(annotated, baseType, builder, elementName));
        }
    }
}

