/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.utils.solder.reflection.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.agorava.utils.solder.reflection.Reflections;

abstract class Parameter<X>
implements AnnotatedElement {
    private final int position;

    static <X> Parameter<X> create(Member declaringMember, int position) {
        if (declaringMember instanceof Method) {
            return new MethodParameter((Method)declaringMember, position);
        }
        if (declaringMember instanceof Constructor) {
            return new ConstructorParameter((Constructor)Reflections.cast((Object)declaringMember), position);
        }
        throw new IllegalArgumentException("Can only process members of type Method and Constructor, cannot process " + declaringMember);
    }

    Parameter(int position) {
        this.position = position;
    }

    public abstract Member getDeclaringMember();

    public int getPosition() {
        return this.position;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getDeclaringMember().hashCode();
        hash = hash * 31 + Integer.valueOf(this.position).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            Parameter that = (Parameter)obj;
            return this.getDeclaringMember().equals(that.getDeclaringMember()) && this.getPosition() == that.getPosition();
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public abstract Type getBaseType();

    private static class ConstructorParameter<X>
    extends Parameter<X> {
        private final Constructor<X> declaringConstructor;

        private ConstructorParameter(Constructor<X> declaringConstructor, int position) {
            super(position);
            this.declaringConstructor = declaringConstructor;
        }

        @Override
        public Constructor<X> getDeclaringMember() {
            return this.declaringConstructor;
        }

        @Override
        public Annotation[] getAnnotations() {
            if (this.declaringConstructor.getParameterAnnotations().length > this.getPosition()) {
                return this.declaringConstructor.getParameterAnnotations()[this.getPosition()];
            }
            return Reflections.EMPTY_ANNOTATION_ARRAY;
        }

        @Override
        public Type getBaseType() {
            if (this.declaringConstructor.getGenericParameterTypes().length > this.getPosition()) {
                return this.declaringConstructor.getGenericParameterTypes()[this.getPosition()];
            }
            return this.declaringConstructor.getParameterTypes()[this.getPosition()];
        }
    }

    private static class MethodParameter<X>
    extends Parameter<X> {
        private final Method declaringMethod;

        private MethodParameter(Method declaringMethod, int position) {
            super(position);
            this.declaringMethod = declaringMethod;
        }

        @Override
        public Method getDeclaringMember() {
            return this.declaringMethod;
        }

        @Override
        public Annotation[] getAnnotations() {
            if (this.declaringMethod.getParameterAnnotations().length > this.getPosition()) {
                return this.declaringMethod.getParameterAnnotations()[this.getPosition()];
            }
            return Reflections.EMPTY_ANNOTATION_ARRAY;
        }

        @Override
        public Type getBaseType() {
            if (this.declaringMethod.getGenericParameterTypes().length > this.getPosition()) {
                return this.declaringMethod.getGenericParameterTypes()[this.getPosition()];
            }
            return this.declaringMethod.getParameterTypes()[this.getPosition()];
        }
    }
}

