/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.utils.solder.reflection.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.agorava.utils.solder.reflection.Reflections;
import org.agorava.utils.solder.reflection.annotated.AnnotationStore;
import org.agorava.utils.solder.support.SolderMessages;

public class AnnotationBuilder {
    private SolderMessages messages;
    private final Map<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Annotation> annotationSet = new HashSet<Annotation>();

    AnnotationBuilder() {
        this.messages = new SolderMessages();
    }

    public AnnotationBuilder add(Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(this.messages.parameterMustNotBeNull("annotation"));
        }
        this.annotationSet.add(annotation);
        this.annotationMap.put(annotation.annotationType(), annotation);
        return this;
    }

    public AnnotationBuilder remove(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException(this.messages.parameterMustNotBeNull("annotationType"));
        }
        Iterator<Annotation> it = this.annotationSet.iterator();
        while (it.hasNext()) {
            Annotation an = it.next();
            if (!annotationType.isAssignableFrom(an.annotationType())) continue;
            it.remove();
        }
        this.annotationMap.remove(annotationType);
        return this;
    }

    AnnotationStore create() {
        return new AnnotationStore(this.annotationMap, this.annotationSet);
    }

    public AnnotationBuilder addAll(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            this.add(annotation);
        }
        return this;
    }

    public AnnotationBuilder addAll(AnnotationStore annotations) {
        for (Annotation annotation : annotations.getAnnotations()) {
            this.add(annotation);
        }
        return this;
    }

    public AnnotationBuilder addAll(AnnotatedElement element) {
        for (Annotation a : element.getAnnotations()) {
            this.add(a);
        }
        return this;
    }

    public <T extends Annotation> T getAnnotation(Class<T> anType) {
        return (T)((Annotation)Reflections.cast((Object)this.annotationMap.get(anType)));
    }

    public boolean isAnnotationPresent(Class<?> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    public String toString() {
        return this.annotationSet.toString();
    }
}

