/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.agorava.api.atinject.BeanResolver;
import org.agorava.linkedin.jackson.LikesListDeserializer;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.jackson.UpdateTypeDeserializer;
import org.agorava.linkedin.model.Comment;
import org.agorava.linkedin.model.LinkedInProfile;
import org.agorava.linkedin.model.UpdateContent;
import org.agorava.linkedin.model.UpdateContentCompany;
import org.agorava.linkedin.model.UpdateContentShare;
import org.agorava.linkedin.model.UpdateType;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class UpdateActionMixin
extends LinkedInObjectMixin {
    @JsonProperty(value="isCommentable")
    boolean commentable;
    @JsonProperty(value="isLikable")
    boolean likeable;
    @JsonProperty(value="isLiked")
    boolean liked;
    @JsonProperty(value="numLikes")
    int numLikes;
    @JsonProperty(value="likes")
    @JsonDeserialize(using=LikesListDeserializer.class)
    List<LinkedInProfile> likes;
    @JsonProperty(value="updateComments")
    @JsonDeserialize(using=CommentsListDeserializer.class)
    List<Comment> updateComments;
    @JsonProperty(value="updateContent")
    @JsonDeserialize(using=UpdateContentDeserializer.class)
    UpdateContent updateContent;

    @JsonCreator
    UpdateActionMixin(@JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="updateKey") String updateKey, @JsonProperty(value="updateType") @JsonDeserialize(using=UpdateTypeDeserializer.class) UpdateType updateType) {
    }

    private static class UpdateContentDeserializer
    extends JsonDeserializer<UpdateContent> {
        private UpdateContentDeserializer() {
        }

        public UpdateContent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)BeanResolver.getInstance().resolve(ObjectMapper.class);
            jp.setCodec((ObjectCodec)mapper);
            JsonNode content = (JsonNode)jp.readValueAs(JsonNode.class);
            JsonNode person = content.get("person");
            JsonNode company = content.get("company");
            if (person != null) {
                return (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentShare>(){}).readValue(person);
            }
            if (company != null) {
                return (UpdateContent)mapper.reader((TypeReference)new TypeReference<UpdateContentCompany>(){}).readValue(content);
            }
            return null;
        }
    }

    private static class CommentsListDeserializer
    extends JsonDeserializer<List<Comment>> {
        private CommentsListDeserializer() {
        }

        public List<Comment> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode dataNode;
            ObjectMapper mapper = (ObjectMapper)BeanResolver.getInstance().resolve(ObjectMapper.class);
            jp.setCodec((ObjectCodec)mapper);
            if (jp.hasCurrentToken() && (dataNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("values")) != null) {
                return (List)mapper.reader((TypeReference)new TypeReference<List<Comment>>(){}).readValue(dataNode);
            }
            return null;
        }
    }
}

