/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.linkedin.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.agorava.linkedin.jackson.LinkedInObjectMixin;
import org.agorava.linkedin.model.LinkedInProfile;
import org.agorava.linkedin.model.Recommendation;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class RecommendationMixin
extends LinkedInObjectMixin {
    @JsonCreator
    RecommendationMixin(@JsonProperty(value="id") String id, @JsonProperty(value="recommendationSnippet") String recommendationSnippet, @JsonProperty(value="recommendationText") String recommendationText, @JsonProperty(value="recommendationType") @JsonDeserialize(using=RecommendationTypeDeserializer.class) Recommendation.RecommendationType recommendationType, @JsonProperty(value="recommender") LinkedInProfile recommender, @JsonProperty(value="recommendee") LinkedInProfile recommendee) {
    }

    private static class RecommendationTypeDeserializer
    extends JsonDeserializer<Recommendation.RecommendationType> {
        private RecommendationTypeDeserializer() {
        }

        public Recommendation.RecommendationType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            return Recommendation.RecommendationType.valueOf((String)node.get("code").textValue().replace('-', '_').toUpperCase());
        }
    }
}

